/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.Step;
import com.amazonaws.services.inspector2.model.transform.NetworkPathMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkPath
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Step> steps;

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<Step> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new ArrayList<Step>(steps);
    }

    public NetworkPath withSteps(Step ... steps) {
        if (this.steps == null) {
            this.setSteps(new ArrayList<Step>(steps.length));
        }
        for (Step ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public NetworkPath withSteps(Collection<Step> steps) {
        this.setSteps(steps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkPath)) {
            return false;
        }
        NetworkPath other = (NetworkPath)obj;
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        return other.getSteps() == null || other.getSteps().equals(this.getSteps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        return hashCode;
    }

    public NetworkPath clone() {
        try {
            return (NetworkPath)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkPathMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

