/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.honeycode.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.honeycode.model.Cell;
import java.util.List;

@SdkInternalApi
public class CellMarshaller {
    private static final MarshallingInfo<String> FORMULA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("formula").build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("format").build();
    private static final MarshallingInfo<String> RAWVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rawValue").build();
    private static final MarshallingInfo<String> FORMATTEDVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("formattedValue").build();
    private static final MarshallingInfo<List> FORMATTEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("formattedValues").build();
    private static final CellMarshaller instance = new CellMarshaller();

    public static CellMarshaller getInstance() {
        return instance;
    }

    public void marshall(Cell cell, ProtocolMarshaller protocolMarshaller) {
        if (cell == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cell.getFormula(), FORMULA_BINDING);
            protocolMarshaller.marshall((Object)cell.getFormat(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)cell.getRawValue(), RAWVALUE_BINDING);
            protocolMarshaller.marshall((Object)cell.getFormattedValue(), FORMATTEDVALUE_BINDING);
            protocolMarshaller.marshall(cell.getFormattedValues(), FORMATTEDVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

