/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.DataQualityResult;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DataQualityResultMarshaller {
    private static final MarshallingInfo<String> RESULTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultId").build();
    private static final MarshallingInfo<Double> SCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Score").build();
    private static final MarshallingInfo<StructuredPojo> DATASOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSource").build();
    private static final MarshallingInfo<String> RULESETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RulesetName").build();
    private static final MarshallingInfo<String> EVALUATIONCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationContext").build();
    private static final MarshallingInfo<Date> STARTEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> COMPLETEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").build();
    private static final MarshallingInfo<String> JOBRUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobRunId").build();
    private static final MarshallingInfo<String> RULESETEVALUATIONRUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RulesetEvaluationRunId").build();
    private static final MarshallingInfo<List> RULERESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleResults").build();
    private static final MarshallingInfo<List> ANALYZERRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnalyzerResults").build();
    private static final MarshallingInfo<List> OBSERVATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Observations").build();
    private static final DataQualityResultMarshaller instance = new DataQualityResultMarshaller();

    public static DataQualityResultMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataQualityResult dataQualityResult, ProtocolMarshaller protocolMarshaller) {
        if (dataQualityResult == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataQualityResult.getResultId(), RESULTID_BINDING);
            protocolMarshaller.marshall((Object)dataQualityResult.getScore(), SCORE_BINDING);
            protocolMarshaller.marshall((Object)dataQualityResult.getDataSource(), DATASOURCE_BINDING);
            protocolMarshaller.marshall((Object)dataQualityResult.getRulesetName(), RULESETNAME_BINDING);
            protocolMarshaller.marshall((Object)dataQualityResult.getEvaluationContext(), EVALUATIONCONTEXT_BINDING);
            protocolMarshaller.marshall((Object)dataQualityResult.getStartedOn(), STARTEDON_BINDING);
            protocolMarshaller.marshall((Object)dataQualityResult.getCompletedOn(), COMPLETEDON_BINDING);
            protocolMarshaller.marshall((Object)dataQualityResult.getJobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)dataQualityResult.getJobRunId(), JOBRUNID_BINDING);
            protocolMarshaller.marshall((Object)dataQualityResult.getRulesetEvaluationRunId(), RULESETEVALUATIONRUNID_BINDING);
            protocolMarshaller.marshall(dataQualityResult.getRuleResults(), RULERESULTS_BINDING);
            protocolMarshaller.marshall(dataQualityResult.getAnalyzerResults(), ANALYZERRESULTS_BINDING);
            protocolMarshaller.marshall(dataQualityResult.getObservations(), OBSERVATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

