/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glue.model.CsvClassifier;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class CsvClassifierMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdated").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<String> DELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Delimiter").build();
    private static final MarshallingInfo<String> QUOTESYMBOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteSymbol").build();
    private static final MarshallingInfo<String> CONTAINSHEADER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContainsHeader").build();
    private static final MarshallingInfo<List> HEADER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Header").build();
    private static final MarshallingInfo<Boolean> DISABLEVALUETRIMMING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisableValueTrimming").build();
    private static final MarshallingInfo<Boolean> ALLOWSINGLECOLUMN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowSingleColumn").build();
    private static final MarshallingInfo<Boolean> CUSTOMDATATYPECONFIGURED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomDatatypeConfigured").build();
    private static final MarshallingInfo<List> CUSTOMDATATYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomDatatypes").build();
    private static final MarshallingInfo<String> SERDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Serde").build();
    private static final CsvClassifierMarshaller instance = new CsvClassifierMarshaller();

    public static CsvClassifierMarshaller getInstance() {
        return instance;
    }

    public void marshall(CsvClassifier csvClassifier, ProtocolMarshaller protocolMarshaller) {
        if (csvClassifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)csvClassifier.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)csvClassifier.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)csvClassifier.getLastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall((Object)csvClassifier.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)csvClassifier.getDelimiter(), DELIMITER_BINDING);
            protocolMarshaller.marshall((Object)csvClassifier.getQuoteSymbol(), QUOTESYMBOL_BINDING);
            protocolMarshaller.marshall((Object)csvClassifier.getContainsHeader(), CONTAINSHEADER_BINDING);
            protocolMarshaller.marshall(csvClassifier.getHeader(), HEADER_BINDING);
            protocolMarshaller.marshall((Object)csvClassifier.getDisableValueTrimming(), DISABLEVALUETRIMMING_BINDING);
            protocolMarshaller.marshall((Object)csvClassifier.getAllowSingleColumn(), ALLOWSINGLECOLUMN_BINDING);
            protocolMarshaller.marshall((Object)csvClassifier.getCustomDatatypeConfigured(), CUSTOMDATATYPECONFIGURED_BINDING);
            protocolMarshaller.marshall(csvClassifier.getCustomDatatypes(), CUSTOMDATATYPES_BINDING);
            protocolMarshaller.marshall((Object)csvClassifier.getSerde(), SERDE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

