/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.transform.PostgreSQLCatalogTargetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PostgreSQLCatalogTarget
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> inputs;
    private String database;
    private String table;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PostgreSQLCatalogTarget withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<String> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<String>(inputs);
    }

    public PostgreSQLCatalogTarget withInputs(String ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<String>(inputs.length));
        }
        for (String ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public PostgreSQLCatalogTarget withInputs(Collection<String> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public PostgreSQLCatalogTarget withDatabase(String database) {
        this.setDatabase(database);
        return this;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public PostgreSQLCatalogTarget withTable(String table) {
        this.setTable(table);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getDatabase() != null) {
            sb.append("Database: ").append(this.getDatabase()).append(",");
        }
        if (this.getTable() != null) {
            sb.append("Table: ").append(this.getTable());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostgreSQLCatalogTarget)) {
            return false;
        }
        PostgreSQLCatalogTarget other = (PostgreSQLCatalogTarget)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getDatabase() == null ^ this.getDatabase() == null) {
            return false;
        }
        if (other.getDatabase() != null && !other.getDatabase().equals(this.getDatabase())) {
            return false;
        }
        if (other.getTable() == null ^ this.getTable() == null) {
            return false;
        }
        return other.getTable() == null || other.getTable().equals(this.getTable());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getDatabase() == null ? 0 : this.getDatabase().hashCode());
        hashCode = 31 * hashCode + (this.getTable() == null ? 0 : this.getTable().hashCode());
        return hashCode;
    }

    public PostgreSQLCatalogTarget clone() {
        try {
            return (PostgreSQLCatalogTarget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PostgreSQLCatalogTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

