/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.IpAddressType;
import com.amazonaws.services.elasticloadbalancingv2.model.SubnetMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SetSubnetsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String loadBalancerArn;
    private List<String> subnets;
    private List<SubnetMapping> subnetMappings;
    private String ipAddressType;

    public void setLoadBalancerArn(String loadBalancerArn) {
        this.loadBalancerArn = loadBalancerArn;
    }

    public String getLoadBalancerArn() {
        return this.loadBalancerArn;
    }

    public SetSubnetsRequest withLoadBalancerArn(String loadBalancerArn) {
        this.setLoadBalancerArn(loadBalancerArn);
        return this;
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new ArrayList<String>(subnets);
    }

    public SetSubnetsRequest withSubnets(String ... subnets) {
        if (this.subnets == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    public SetSubnetsRequest withSubnets(Collection<String> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public List<SubnetMapping> getSubnetMappings() {
        return this.subnetMappings;
    }

    public void setSubnetMappings(Collection<SubnetMapping> subnetMappings) {
        if (subnetMappings == null) {
            this.subnetMappings = null;
            return;
        }
        this.subnetMappings = new ArrayList<SubnetMapping>(subnetMappings);
    }

    public SetSubnetsRequest withSubnetMappings(SubnetMapping ... subnetMappings) {
        if (this.subnetMappings == null) {
            this.setSubnetMappings(new ArrayList<SubnetMapping>(subnetMappings.length));
        }
        for (SubnetMapping ele : subnetMappings) {
            this.subnetMappings.add(ele);
        }
        return this;
    }

    public SetSubnetsRequest withSubnetMappings(Collection<SubnetMapping> subnetMappings) {
        this.setSubnetMappings(subnetMappings);
        return this;
    }

    public void setIpAddressType(String ipAddressType) {
        this.ipAddressType = ipAddressType;
    }

    public String getIpAddressType() {
        return this.ipAddressType;
    }

    public SetSubnetsRequest withIpAddressType(String ipAddressType) {
        this.setIpAddressType(ipAddressType);
        return this;
    }

    public SetSubnetsRequest withIpAddressType(IpAddressType ipAddressType) {
        this.ipAddressType = ipAddressType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.getLoadBalancerArn()).append(",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: ").append(this.getSubnets()).append(",");
        }
        if (this.getSubnetMappings() != null) {
            sb.append("SubnetMappings: ").append(this.getSubnetMappings()).append(",");
        }
        if (this.getIpAddressType() != null) {
            sb.append("IpAddressType: ").append(this.getIpAddressType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubnetsRequest)) {
            return false;
        }
        SetSubnetsRequest other = (SetSubnetsRequest)obj;
        if (other.getLoadBalancerArn() == null ^ this.getLoadBalancerArn() == null) {
            return false;
        }
        if (other.getLoadBalancerArn() != null && !other.getLoadBalancerArn().equals(this.getLoadBalancerArn())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        if (other.getSubnets() != null && !other.getSubnets().equals(this.getSubnets())) {
            return false;
        }
        if (other.getSubnetMappings() == null ^ this.getSubnetMappings() == null) {
            return false;
        }
        if (other.getSubnetMappings() != null && !other.getSubnetMappings().equals(this.getSubnetMappings())) {
            return false;
        }
        if (other.getIpAddressType() == null ^ this.getIpAddressType() == null) {
            return false;
        }
        return other.getIpAddressType() == null || other.getIpAddressType().equals(this.getIpAddressType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerArn() == null ? 0 : this.getLoadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetMappings() == null ? 0 : this.getSubnetMappings().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddressType() == null ? 0 : this.getIpAddressType().hashCode());
        return hashCode;
    }

    public SetSubnetsRequest clone() {
        return (SetSubnetsRequest)super.clone();
    }
}

