/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecr.model.ImageIdentifier;

@SdkInternalApi
public class ImageIdentifierMarshaller {
    private static final MarshallingInfo<String> IMAGEDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageDigest").build();
    private static final MarshallingInfo<String> IMAGETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageTag").build();
    private static final ImageIdentifierMarshaller instance = new ImageIdentifierMarshaller();

    public static ImageIdentifierMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageIdentifier imageIdentifier, ProtocolMarshaller protocolMarshaller) {
        if (imageIdentifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageIdentifier.getImageDigest(), IMAGEDIGEST_BINDING);
            protocolMarshaller.marshall((Object)imageIdentifier.getImageTag(), IMAGETAG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

