/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeIpamPoolsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeIpamPoolsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeIpamPoolsRequest> {
    private SdkInternalList<Filter> filters;
    private Integer maxResults;
    private String nextToken;
    private SdkInternalList<String> ipamPoolIds;

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public DescribeIpamPoolsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<Filter>)new SdkInternalList(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public DescribeIpamPoolsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeIpamPoolsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeIpamPoolsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getIpamPoolIds() {
        if (this.ipamPoolIds == null) {
            this.ipamPoolIds = new SdkInternalList();
        }
        return this.ipamPoolIds;
    }

    public void setIpamPoolIds(Collection<String> ipamPoolIds) {
        if (ipamPoolIds == null) {
            this.ipamPoolIds = null;
            return;
        }
        this.ipamPoolIds = new SdkInternalList(ipamPoolIds);
    }

    public DescribeIpamPoolsRequest withIpamPoolIds(String ... ipamPoolIds) {
        if (this.ipamPoolIds == null) {
            this.setIpamPoolIds((Collection<String>)new SdkInternalList(ipamPoolIds.length));
        }
        for (String ele : ipamPoolIds) {
            this.ipamPoolIds.add((Object)ele);
        }
        return this;
    }

    public DescribeIpamPoolsRequest withIpamPoolIds(Collection<String> ipamPoolIds) {
        this.setIpamPoolIds(ipamPoolIds);
        return this;
    }

    @Override
    public Request<DescribeIpamPoolsRequest> getDryRunRequest() {
        Request<DescribeIpamPoolsRequest> request = new DescribeIpamPoolsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getIpamPoolIds() != null) {
            sb.append("IpamPoolIds: ").append(this.getIpamPoolIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamPoolsRequest)) {
            return false;
        }
        DescribeIpamPoolsRequest other = (DescribeIpamPoolsRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getIpamPoolIds() == null ^ this.getIpamPoolIds() == null) {
            return false;
        }
        return other.getIpamPoolIds() == null || other.getIpamPoolIds().equals(this.getIpamPoolIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getIpamPoolIds() == null ? 0 : this.getIpamPoolIds().hashCode());
        return hashCode;
    }

    public DescribeIpamPoolsRequest clone() {
        return (DescribeIpamPoolsRequest)super.clone();
    }
}

