/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.VolumeType;
import com.amazonaws.services.ec2.model.transform.CreateVolumeRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateVolumeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateVolumeRequest> {
    private String availabilityZone;
    private Boolean encrypted;
    private Integer iops;
    private String kmsKeyId;
    private String outpostArn;
    private Integer size;
    private String snapshotId;
    private String volumeType;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public CreateVolumeRequest() {
    }

    public CreateVolumeRequest(Integer size, String availabilityZone) {
        this.setSize(size);
        this.setAvailabilityZone(availabilityZone);
    }

    public CreateVolumeRequest(String snapshotId, String availabilityZone) {
        this.setSnapshotId(snapshotId);
        this.setAvailabilityZone(availabilityZone);
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public CreateVolumeRequest withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public CreateVolumeRequest withEncrypted(Boolean encrypted) {
        this.setEncrypted(encrypted);
        return this;
    }

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public Integer getIops() {
        return this.iops;
    }

    public CreateVolumeRequest withIops(Integer iops) {
        this.setIops(iops);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CreateVolumeRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setOutpostArn(String outpostArn) {
        this.outpostArn = outpostArn;
    }

    public String getOutpostArn() {
        return this.outpostArn;
    }

    public CreateVolumeRequest withOutpostArn(String outpostArn) {
        this.setOutpostArn(outpostArn);
        return this;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public CreateVolumeRequest withSize(Integer size) {
        this.setSize(size);
        return this;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public CreateVolumeRequest withSnapshotId(String snapshotId) {
        this.setSnapshotId(snapshotId);
        return this;
    }

    public void setVolumeType(String volumeType) {
        this.volumeType = volumeType;
    }

    public String getVolumeType() {
        return this.volumeType;
    }

    public CreateVolumeRequest withVolumeType(String volumeType) {
        this.setVolumeType(volumeType);
        return this;
    }

    public void setVolumeType(VolumeType volumeType) {
        this.withVolumeType(volumeType);
    }

    public CreateVolumeRequest withVolumeType(VolumeType volumeType) {
        this.volumeType = volumeType.toString();
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateVolumeRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateVolumeRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateVolumeRequest> getDryRunRequest() {
        Request<CreateVolumeRequest> request = new CreateVolumeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getEncrypted() != null) {
            sb.append("Encrypted: ").append(this.getEncrypted()).append(",");
        }
        if (this.getIops() != null) {
            sb.append("Iops: ").append(this.getIops()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getOutpostArn() != null) {
            sb.append("OutpostArn: ").append(this.getOutpostArn()).append(",");
        }
        if (this.getSize() != null) {
            sb.append("Size: ").append(this.getSize()).append(",");
        }
        if (this.getSnapshotId() != null) {
            sb.append("SnapshotId: ").append(this.getSnapshotId()).append(",");
        }
        if (this.getVolumeType() != null) {
            sb.append("VolumeType: ").append(this.getVolumeType()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumeRequest)) {
            return false;
        }
        CreateVolumeRequest other = (CreateVolumeRequest)obj;
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getEncrypted() == null ^ this.getEncrypted() == null) {
            return false;
        }
        if (other.getEncrypted() != null && !other.getEncrypted().equals(this.getEncrypted())) {
            return false;
        }
        if (other.getIops() == null ^ this.getIops() == null) {
            return false;
        }
        if (other.getIops() != null && !other.getIops().equals(this.getIops())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getOutpostArn() == null ^ this.getOutpostArn() == null) {
            return false;
        }
        if (other.getOutpostArn() != null && !other.getOutpostArn().equals(this.getOutpostArn())) {
            return false;
        }
        if (other.getSize() == null ^ this.getSize() == null) {
            return false;
        }
        if (other.getSize() != null && !other.getSize().equals(this.getSize())) {
            return false;
        }
        if (other.getSnapshotId() == null ^ this.getSnapshotId() == null) {
            return false;
        }
        if (other.getSnapshotId() != null && !other.getSnapshotId().equals(this.getSnapshotId())) {
            return false;
        }
        if (other.getVolumeType() == null ^ this.getVolumeType() == null) {
            return false;
        }
        if (other.getVolumeType() != null && !other.getVolumeType().equals(this.getVolumeType())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getEncrypted() == null ? 0 : this.getEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getIops() == null ? 0 : this.getIops().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getOutpostArn() == null ? 0 : this.getOutpostArn().hashCode());
        hashCode = 31 * hashCode + (this.getSize() == null ? 0 : this.getSize().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotId() == null ? 0 : this.getSnapshotId().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeType() == null ? 0 : this.getVolumeType().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    public CreateVolumeRequest clone() {
        return (CreateVolumeRequest)super.clone();
    }
}

