/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.config.model.ConfigurationItem;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ConfigurationItemMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<Date> CONFIGURATIONITEMCAPTURETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemCaptureTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CONFIGURATIONITEMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemStatus").build();
    private static final MarshallingInfo<String> CONFIGURATIONSTATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationStateId").build();
    private static final MarshallingInfo<String> CONFIGURATIONITEMMD5HASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemMD5Hash").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").build();
    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsRegion").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").build();
    private static final MarshallingInfo<Date> RESOURCECREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceCreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<List> RELATEDEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relatedEvents").build();
    private static final MarshallingInfo<List> RELATIONSHIPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relationships").build();
    private static final MarshallingInfo<String> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").build();
    private static final MarshallingInfo<Map> SUPPLEMENTARYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supplementaryConfiguration").build();
    private static final MarshallingInfo<String> RECORDINGFREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recordingFrequency").build();
    private static final MarshallingInfo<Date> CONFIGURATIONITEMDELIVERYTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemDeliveryTime").timestampFormat("unixTimestamp").build();
    private static final ConfigurationItemMarshaller instance = new ConfigurationItemMarshaller();

    public static ConfigurationItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConfigurationItem configurationItem, ProtocolMarshaller protocolMarshaller) {
        if (configurationItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)configurationItem.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getConfigurationItemCaptureTime(), CONFIGURATIONITEMCAPTURETIME_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getConfigurationItemStatus(), CONFIGURATIONITEMSTATUS_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getConfigurationStateId(), CONFIGURATIONSTATEID_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getConfigurationItemMD5Hash(), CONFIGURATIONITEMMD5HASH_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getResourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getResourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getAwsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getAvailabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getResourceCreationTime(), RESOURCECREATIONTIME_BINDING);
            protocolMarshaller.marshall(configurationItem.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(configurationItem.getRelatedEvents(), RELATEDEVENTS_BINDING);
            protocolMarshaller.marshall(configurationItem.getRelationships(), RELATIONSHIPS_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getConfiguration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall(configurationItem.getSupplementaryConfiguration(), SUPPLEMENTARYCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getRecordingFrequency(), RECORDINGFREQUENCY_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.getConfigurationItemDeliveryTime(), CONFIGURATIONITEMDELIVERYTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

