/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.ListDiscoveredResourcesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListDiscoveredResourcesRequestMarshaller
implements Marshaller<Request<ListDiscoveredResourcesRequest>, ListDiscoveredResourcesRequest> {
    public Request<ListDiscoveredResourcesRequest> marshall(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        if (listDiscoveredResourcesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDiscoveredResourcesRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.ListDiscoveredResources");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList resourceIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (listDiscoveredResourcesRequest.getResourceType() != null) {
                jsonWriter.key("resourceType").value((Object)listDiscoveredResourcesRequest.getResourceType());
            }
            if (!(resourceIdsList = (SdkInternalList)listDiscoveredResourcesRequest.getResourceIds()).isEmpty() || !resourceIdsList.isAutoConstruct()) {
                jsonWriter.key("resourceIds");
                jsonWriter.array();
                for (String resourceIdsListValue : resourceIdsList) {
                    if (resourceIdsListValue == null) continue;
                    jsonWriter.value((Object)resourceIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (listDiscoveredResourcesRequest.getResourceName() != null) {
                jsonWriter.key("resourceName").value((Object)listDiscoveredResourcesRequest.getResourceName());
            }
            if (listDiscoveredResourcesRequest.getLimit() != null) {
                jsonWriter.key("limit").value((Object)listDiscoveredResourcesRequest.getLimit());
            }
            if (listDiscoveredResourcesRequest.getIncludeDeletedResources() != null) {
                jsonWriter.key("includeDeletedResources").value((Object)listDiscoveredResourcesRequest.getIncludeDeletedResources());
            }
            if (listDiscoveredResourcesRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value((Object)listDiscoveredResourcesRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

