/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codepipeline.model.PipelineDeclaration;
import com.amazonaws.services.codepipeline.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreatePipelineRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private PipelineDeclaration pipeline;
    private List<Tag> tags;

    public void setPipeline(PipelineDeclaration pipeline) {
        this.pipeline = pipeline;
    }

    public PipelineDeclaration getPipeline() {
        return this.pipeline;
    }

    public CreatePipelineRequest withPipeline(PipelineDeclaration pipeline) {
        this.setPipeline(pipeline);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreatePipelineRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreatePipelineRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipeline() != null) {
            sb.append("Pipeline: ").append(this.getPipeline()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineRequest)) {
            return false;
        }
        CreatePipelineRequest other = (CreatePipelineRequest)obj;
        if (other.getPipeline() == null ^ this.getPipeline() == null) {
            return false;
        }
        if (other.getPipeline() != null && !other.getPipeline().equals(this.getPipeline())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipeline() == null ? 0 : this.getPipeline().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreatePipelineRequest clone() {
        return (CreatePipelineRequest)super.clone();
    }
}

