/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model.transform;

import com.amazonaws.services.bedrockruntime.model.DocumentSource;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class DocumentSourceJsonUnmarshaller
implements Unmarshaller<DocumentSource, JsonUnmarshallerContext> {
    private static DocumentSourceJsonUnmarshaller instance;

    public DocumentSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        DocumentSource documentSource = new DocumentSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bytes", targetDepth)) {
                    context.nextToken();
                    documentSource.setBytes((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return documentSource;
    }

    public static DocumentSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DocumentSourceJsonUnmarshaller();
        }
        return instance;
    }
}

