/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.WebCrawlerLimits;
import com.amazonaws.services.bedrockagent.model.WebScopeType;
import com.amazonaws.services.bedrockagent.model.transform.WebCrawlerConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WebCrawlerConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private WebCrawlerLimits crawlerLimits;
    private List<String> exclusionFilters;
    private List<String> inclusionFilters;
    private String scope;

    public void setCrawlerLimits(WebCrawlerLimits crawlerLimits) {
        this.crawlerLimits = crawlerLimits;
    }

    public WebCrawlerLimits getCrawlerLimits() {
        return this.crawlerLimits;
    }

    public WebCrawlerConfiguration withCrawlerLimits(WebCrawlerLimits crawlerLimits) {
        this.setCrawlerLimits(crawlerLimits);
        return this;
    }

    public List<String> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(Collection<String> exclusionFilters) {
        if (exclusionFilters == null) {
            this.exclusionFilters = null;
            return;
        }
        this.exclusionFilters = new ArrayList<String>(exclusionFilters);
    }

    public WebCrawlerConfiguration withExclusionFilters(String ... exclusionFilters) {
        if (this.exclusionFilters == null) {
            this.setExclusionFilters(new ArrayList<String>(exclusionFilters.length));
        }
        for (String ele : exclusionFilters) {
            this.exclusionFilters.add(ele);
        }
        return this;
    }

    public WebCrawlerConfiguration withExclusionFilters(Collection<String> exclusionFilters) {
        this.setExclusionFilters(exclusionFilters);
        return this;
    }

    public List<String> getInclusionFilters() {
        return this.inclusionFilters;
    }

    public void setInclusionFilters(Collection<String> inclusionFilters) {
        if (inclusionFilters == null) {
            this.inclusionFilters = null;
            return;
        }
        this.inclusionFilters = new ArrayList<String>(inclusionFilters);
    }

    public WebCrawlerConfiguration withInclusionFilters(String ... inclusionFilters) {
        if (this.inclusionFilters == null) {
            this.setInclusionFilters(new ArrayList<String>(inclusionFilters.length));
        }
        for (String ele : inclusionFilters) {
            this.inclusionFilters.add(ele);
        }
        return this;
    }

    public WebCrawlerConfiguration withInclusionFilters(Collection<String> inclusionFilters) {
        this.setInclusionFilters(inclusionFilters);
        return this;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public WebCrawlerConfiguration withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public WebCrawlerConfiguration withScope(WebScopeType scope) {
        this.scope = scope.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCrawlerLimits() != null) {
            sb.append("CrawlerLimits: ").append(this.getCrawlerLimits()).append(",");
        }
        if (this.getExclusionFilters() != null) {
            sb.append("ExclusionFilters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getInclusionFilters() != null) {
            sb.append("InclusionFilters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebCrawlerConfiguration)) {
            return false;
        }
        WebCrawlerConfiguration other = (WebCrawlerConfiguration)obj;
        if (other.getCrawlerLimits() == null ^ this.getCrawlerLimits() == null) {
            return false;
        }
        if (other.getCrawlerLimits() != null && !other.getCrawlerLimits().equals(this.getCrawlerLimits())) {
            return false;
        }
        if (other.getExclusionFilters() == null ^ this.getExclusionFilters() == null) {
            return false;
        }
        if (other.getExclusionFilters() != null && !other.getExclusionFilters().equals(this.getExclusionFilters())) {
            return false;
        }
        if (other.getInclusionFilters() == null ^ this.getInclusionFilters() == null) {
            return false;
        }
        if (other.getInclusionFilters() != null && !other.getInclusionFilters().equals(this.getInclusionFilters())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        return other.getScope() == null || other.getScope().equals(this.getScope());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCrawlerLimits() == null ? 0 : this.getCrawlerLimits().hashCode());
        hashCode = 31 * hashCode + (this.getExclusionFilters() == null ? 0 : this.getExclusionFilters().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionFilters() == null ? 0 : this.getInclusionFilters().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        return hashCode;
    }

    public WebCrawlerConfiguration clone() {
        try {
            return (WebCrawlerConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebCrawlerConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

