/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backup.model.CreateFrameworkRequest;
import com.amazonaws.util.IdempotentUtils;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class CreateFrameworkRequestMarshaller {
    private static final MarshallingInfo<String> FRAMEWORKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameworkName").build();
    private static final MarshallingInfo<String> FRAMEWORKDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameworkDescription").build();
    private static final MarshallingInfo<List> FRAMEWORKCONTROLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameworkControls").build();
    private static final MarshallingInfo<String> IDEMPOTENCYTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdempotencyToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<Map> FRAMEWORKTAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameworkTags").build();
    private static final CreateFrameworkRequestMarshaller instance = new CreateFrameworkRequestMarshaller();

    public static CreateFrameworkRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(CreateFrameworkRequest createFrameworkRequest, ProtocolMarshaller protocolMarshaller) {
        if (createFrameworkRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createFrameworkRequest.getFrameworkName(), FRAMEWORKNAME_BINDING);
            protocolMarshaller.marshall((Object)createFrameworkRequest.getFrameworkDescription(), FRAMEWORKDESCRIPTION_BINDING);
            protocolMarshaller.marshall(createFrameworkRequest.getFrameworkControls(), FRAMEWORKCONTROLS_BINDING);
            protocolMarshaller.marshall((Object)createFrameworkRequest.getIdempotencyToken(), IDEMPOTENCYTOKEN_BINDING);
            protocolMarshaller.marshall(createFrameworkRequest.getFrameworkTags(), FRAMEWORKTAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

