/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationcostprofiler;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.applicationcostprofiler.AWSApplicationCostProfilerAsync;
import com.amazonaws.services.applicationcostprofiler.AWSApplicationCostProfilerAsyncClientBuilder;
import com.amazonaws.services.applicationcostprofiler.AWSApplicationCostProfilerClient;
import com.amazonaws.services.applicationcostprofiler.model.DeleteReportDefinitionRequest;
import com.amazonaws.services.applicationcostprofiler.model.DeleteReportDefinitionResult;
import com.amazonaws.services.applicationcostprofiler.model.GetReportDefinitionRequest;
import com.amazonaws.services.applicationcostprofiler.model.GetReportDefinitionResult;
import com.amazonaws.services.applicationcostprofiler.model.ImportApplicationUsageRequest;
import com.amazonaws.services.applicationcostprofiler.model.ImportApplicationUsageResult;
import com.amazonaws.services.applicationcostprofiler.model.ListReportDefinitionsRequest;
import com.amazonaws.services.applicationcostprofiler.model.ListReportDefinitionsResult;
import com.amazonaws.services.applicationcostprofiler.model.PutReportDefinitionRequest;
import com.amazonaws.services.applicationcostprofiler.model.PutReportDefinitionResult;
import com.amazonaws.services.applicationcostprofiler.model.UpdateReportDefinitionRequest;
import com.amazonaws.services.applicationcostprofiler.model.UpdateReportDefinitionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSApplicationCostProfilerAsyncClient
extends AWSApplicationCostProfilerClient
implements AWSApplicationCostProfilerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSApplicationCostProfilerAsyncClientBuilder asyncBuilder() {
        return AWSApplicationCostProfilerAsyncClientBuilder.standard();
    }

    AWSApplicationCostProfilerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSApplicationCostProfilerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteReportDefinitionResult> deleteReportDefinitionAsync(DeleteReportDefinitionRequest request) {
        return this.deleteReportDefinitionAsync(request, null);
    }

    @Override
    public Future<DeleteReportDefinitionResult> deleteReportDefinitionAsync(DeleteReportDefinitionRequest request, final AsyncHandler<DeleteReportDefinitionRequest, DeleteReportDefinitionResult> asyncHandler) {
        final DeleteReportDefinitionRequest finalRequest = (DeleteReportDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteReportDefinitionResult>(){

            @Override
            public DeleteReportDefinitionResult call() throws Exception {
                DeleteReportDefinitionResult result = null;
                try {
                    result = AWSApplicationCostProfilerAsyncClient.this.executeDeleteReportDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReportDefinitionResult> getReportDefinitionAsync(GetReportDefinitionRequest request) {
        return this.getReportDefinitionAsync(request, null);
    }

    @Override
    public Future<GetReportDefinitionResult> getReportDefinitionAsync(GetReportDefinitionRequest request, final AsyncHandler<GetReportDefinitionRequest, GetReportDefinitionResult> asyncHandler) {
        final GetReportDefinitionRequest finalRequest = (GetReportDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReportDefinitionResult>(){

            @Override
            public GetReportDefinitionResult call() throws Exception {
                GetReportDefinitionResult result = null;
                try {
                    result = AWSApplicationCostProfilerAsyncClient.this.executeGetReportDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportApplicationUsageResult> importApplicationUsageAsync(ImportApplicationUsageRequest request) {
        return this.importApplicationUsageAsync(request, null);
    }

    @Override
    public Future<ImportApplicationUsageResult> importApplicationUsageAsync(ImportApplicationUsageRequest request, final AsyncHandler<ImportApplicationUsageRequest, ImportApplicationUsageResult> asyncHandler) {
        final ImportApplicationUsageRequest finalRequest = (ImportApplicationUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportApplicationUsageResult>(){

            @Override
            public ImportApplicationUsageResult call() throws Exception {
                ImportApplicationUsageResult result = null;
                try {
                    result = AWSApplicationCostProfilerAsyncClient.this.executeImportApplicationUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReportDefinitionsResult> listReportDefinitionsAsync(ListReportDefinitionsRequest request) {
        return this.listReportDefinitionsAsync(request, null);
    }

    @Override
    public Future<ListReportDefinitionsResult> listReportDefinitionsAsync(ListReportDefinitionsRequest request, final AsyncHandler<ListReportDefinitionsRequest, ListReportDefinitionsResult> asyncHandler) {
        final ListReportDefinitionsRequest finalRequest = (ListReportDefinitionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReportDefinitionsResult>(){

            @Override
            public ListReportDefinitionsResult call() throws Exception {
                ListReportDefinitionsResult result = null;
                try {
                    result = AWSApplicationCostProfilerAsyncClient.this.executeListReportDefinitions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutReportDefinitionResult> putReportDefinitionAsync(PutReportDefinitionRequest request) {
        return this.putReportDefinitionAsync(request, null);
    }

    @Override
    public Future<PutReportDefinitionResult> putReportDefinitionAsync(PutReportDefinitionRequest request, final AsyncHandler<PutReportDefinitionRequest, PutReportDefinitionResult> asyncHandler) {
        final PutReportDefinitionRequest finalRequest = (PutReportDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutReportDefinitionResult>(){

            @Override
            public PutReportDefinitionResult call() throws Exception {
                PutReportDefinitionResult result = null;
                try {
                    result = AWSApplicationCostProfilerAsyncClient.this.executePutReportDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateReportDefinitionResult> updateReportDefinitionAsync(UpdateReportDefinitionRequest request) {
        return this.updateReportDefinitionAsync(request, null);
    }

    @Override
    public Future<UpdateReportDefinitionResult> updateReportDefinitionAsync(UpdateReportDefinitionRequest request, final AsyncHandler<UpdateReportDefinitionRequest, UpdateReportDefinitionResult> asyncHandler) {
        final UpdateReportDefinitionRequest finalRequest = (UpdateReportDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateReportDefinitionResult>(){

            @Override
            public UpdateReportDefinitionResult call() throws Exception {
                UpdateReportDefinitionResult result = null;
                try {
                    result = AWSApplicationCostProfilerAsyncClient.this.executeUpdateReportDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

