/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import java.util.HashMap;
import java.util.Map;

public enum SigningAlgorithmSpec {
    RSASSA_PSS_SHA_256("RSASSA_PSS_SHA_256"),
    RSASSA_PSS_SHA_384("RSASSA_PSS_SHA_384"),
    RSASSA_PSS_SHA_512("RSASSA_PSS_SHA_512"),
    RSASSA_PKCS1_V1_5_SHA_256("RSASSA_PKCS1_V1_5_SHA_256"),
    RSASSA_PKCS1_V1_5_SHA_384("RSASSA_PKCS1_V1_5_SHA_384"),
    RSASSA_PKCS1_V1_5_SHA_512("RSASSA_PKCS1_V1_5_SHA_512"),
    ECDSA_SHA_256("ECDSA_SHA_256"),
    ECDSA_SHA_384("ECDSA_SHA_384"),
    ECDSA_SHA_512("ECDSA_SHA_512"),
    SM2DSA("SM2DSA");

    private String value;
    private static final Map<String, SigningAlgorithmSpec> enumMap;

    private SigningAlgorithmSpec(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static SigningAlgorithmSpec fromValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        if (enumMap.containsKey(value)) {
            return enumMap.get(value);
        }
        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }

    static {
        enumMap = new HashMap<String, SigningAlgorithmSpec>();
        enumMap.put("RSASSA_PSS_SHA_256", RSASSA_PSS_SHA_256);
        enumMap.put("RSASSA_PSS_SHA_384", RSASSA_PSS_SHA_384);
        enumMap.put("RSASSA_PSS_SHA_512", RSASSA_PSS_SHA_512);
        enumMap.put("RSASSA_PKCS1_V1_5_SHA_256", RSASSA_PKCS1_V1_5_SHA_256);
        enumMap.put("RSASSA_PKCS1_V1_5_SHA_384", RSASSA_PKCS1_V1_5_SHA_384);
        enumMap.put("RSASSA_PKCS1_V1_5_SHA_512", RSASSA_PKCS1_V1_5_SHA_512);
        enumMap.put("ECDSA_SHA_256", ECDSA_SHA_256);
        enumMap.put("ECDSA_SHA_384", ECDSA_SHA_384);
        enumMap.put("ECDSA_SHA_512", ECDSA_SHA_512);
        enumMap.put("SM2DSA", SM2DSA);
    }
}

