/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.services.kms.model.GrantListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListGrantsResult
implements Serializable {
    private List<GrantListEntry> grants = new ArrayList<GrantListEntry>();
    private String nextMarker;
    private Boolean truncated;

    public List<GrantListEntry> getGrants() {
        return this.grants;
    }

    public void setGrants(Collection<GrantListEntry> grants) {
        if (grants == null) {
            this.grants = null;
            return;
        }
        this.grants = new ArrayList<GrantListEntry>(grants);
    }

    public ListGrantsResult withGrants(GrantListEntry ... grants) {
        if (this.getGrants() == null) {
            this.grants = new ArrayList<GrantListEntry>(grants.length);
        }
        for (GrantListEntry value : grants) {
            this.grants.add(value);
        }
        return this;
    }

    public ListGrantsResult withGrants(Collection<GrantListEntry> grants) {
        this.setGrants(grants);
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public ListGrantsResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public Boolean isTruncated() {
        return this.truncated;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        this.truncated = truncated;
    }

    public ListGrantsResult withTruncated(Boolean truncated) {
        this.truncated = truncated;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGrants() != null) {
            sb.append("Grants: " + this.getGrants() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.getTruncated() != null) {
            sb.append("Truncated: " + this.getTruncated());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGrants() == null ? 0 : this.getGrants().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getTruncated() == null ? 0 : this.getTruncated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGrantsResult)) {
            return false;
        }
        ListGrantsResult other = (ListGrantsResult)obj;
        if (other.getGrants() == null ^ this.getGrants() == null) {
            return false;
        }
        if (other.getGrants() != null && !other.getGrants().equals(this.getGrants())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getTruncated() == null ^ this.getTruncated() == null) {
            return false;
        }
        return other.getTruncated() == null || other.getTruncated().equals(this.getTruncated());
    }
}

