/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.internal.BlockedOnParentShardException;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockOnParentShardTask
implements ITask {
    private static final Log LOG = LogFactory.getLog(BlockOnParentShardTask.class);
    private final ShardInfo shardInfo;
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private final TaskType taskType = TaskType.BLOCK_ON_PARENT_SHARDS;
    private final long parentShardPollIntervalMillis;

    public BlockOnParentShardTask(ShardInfo shardInfo, ILeaseManager<KinesisClientLease> leaseManager, long parentShardPollIntervalMillis) {
        this.shardInfo = shardInfo;
        this.leaseManager = leaseManager;
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
    }

    @Override
    public TaskResult call() {
        Exception exception = null;
        try {
            boolean blockedOnParentShard = false;
            for (String shardId : this.shardInfo.getParentShardIds()) {
                KinesisClientLease lease = this.leaseManager.getLease(shardId);
                if (lease != null) {
                    ExtendedSequenceNumber checkpoint = lease.getCheckpoint();
                    if (checkpoint == null || !checkpoint.equals(ExtendedSequenceNumber.SHARD_END)) {
                        LOG.debug((Object)("Shard " + shardId + " is not yet done. Its current checkpoint is " + checkpoint));
                        blockedOnParentShard = true;
                        exception = new BlockedOnParentShardException("Parent shard not yet done");
                        break;
                    }
                    LOG.debug((Object)("Shard " + shardId + " has been completely processed."));
                    continue;
                }
                LOG.info((Object)("No lease found for shard " + shardId + ". Not blocking on completion of this shard."));
            }
            if (!blockedOnParentShard) {
                LOG.info((Object)("No need to block on parents " + this.shardInfo.getParentShardIds() + " of shard " + this.shardInfo.getShardId()));
                return new TaskResult(null);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Caught exception when checking for parent shard checkpoint", (Throwable)e);
            exception = e;
        }
        try {
            Thread.sleep(this.parentShardPollIntervalMillis);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Sleep interrupted when waiting on parent shard(s) of " + this.shardInfo.getShardId()), (Throwable)e);
        }
        return new TaskResult(exception);
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }
}

