/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.iterable;

import com.aliyun.oss.OSS;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import java.util.Iterator;

public class OSSObjects
implements Iterable<OSSObjectSummary> {
    private OSS oss;
    private ObjectListing objectListing;

    private OSSObjects(OSS oss, ObjectListing objectListing) {
        CodingUtils.assertParameterNotNull(oss, "oss");
        CodingUtils.assertParameterNotNull(objectListing, "objectListing");
        CodingUtils.assertParameterNotNull(objectListing.getBucketName(), "objectListing.bucketName");
        this.oss = oss;
        this.objectListing = objectListing;
    }

    public static OSSObjects withObjectListing(OSS oss, ObjectListing objectListing) {
        return new OSSObjects(oss, objectListing);
    }

    @Override
    public Iterator<OSSObjectSummary> iterator() {
        return new OSSObjectIterator();
    }

    private class OSSObjectIterator
    implements Iterator<OSSObjectSummary> {
        private ObjectListing currentListing;
        private Iterator<OSSObjectSummary> currentIter;

        private OSSObjectIterator() {
            this.currentListing = OSSObjects.this.objectListing;
            this.currentIter = OSSObjects.this.objectListing.getObjectSummaries().iterator();
        }

        @Override
        public boolean hasNext() {
            this.prepare();
            return this.currentIter.hasNext();
        }

        @Override
        public OSSObjectSummary next() {
            this.prepare();
            return this.currentIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void prepare() {
            if (this.currentListing.isTruncated() && !this.currentIter.hasNext()) {
                ObjectListing nextObjectListing;
                ListObjectsRequest listObjectsRequest = new ListObjectsRequest(OSSObjects.this.objectListing.getBucketName());
                listObjectsRequest.setDelimiter(this.currentListing.getDelimiter());
                listObjectsRequest.setMarker(this.currentListing.getNextMarker());
                listObjectsRequest.setMaxKeys(this.currentListing.getMaxKeys());
                listObjectsRequest.setPrefix(this.currentListing.getPrefix());
                this.currentListing = nextObjectListing = OSSObjects.this.oss.listObjects(listObjectsRequest);
                this.currentIter = nextObjectListing.getObjectSummaries().iterator();
            }
        }
    }
}

