/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.statistics;

import java.util.concurrent.atomic.AtomicInteger;

public class Histogram {
    private final String title;
    private final int grade;
    private final String[] labels;
    private final AtomicInteger[] values;

    public Histogram(String title, String[] labels) {
        this.title = title;
        this.labels = labels;
        this.grade = labels.length;
        this.values = new AtomicInteger[this.grade];
        for (int i = 0; i < this.grade; ++i) {
            this.values[i] = new AtomicInteger(0);
        }
    }

    public void add(long index) {
        if (index < 0L) {
            return;
        }
        if (index >= (long)this.grade) {
            index = this.grade - 1;
        }
        this.values[(int)index].incrementAndGet();
    }

    public String report(boolean reset) {
        StringBuilder sb = new StringBuilder(this.title);
        sb.append(": [");
        for (int i = 0; i < this.grade; ++i) {
            sb.append(this.labels[i]).append(": ");
            if (reset) {
                sb.append(this.values[i].getAndSet(0));
            } else {
                sb.append(this.values[i].get());
            }
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append("]");
        return sb.toString();
    }
}

