/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.metrics;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.metrics.NopLongHistogram;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.metrics.RemotingMetricsConstant;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.opentelemetry.api.common.Attributes;
import com.aliyun.openservices.shade.io.opentelemetry.api.common.AttributesBuilder;
import com.aliyun.openservices.shade.io.opentelemetry.api.metrics.LongHistogram;
import com.aliyun.openservices.shade.io.opentelemetry.api.metrics.Meter;
import java.util.function.Supplier;

public class RemotingMetricsManager {
    public static LongHistogram rpcLatency = new NopLongHistogram();
    public static Supplier<AttributesBuilder> attributesBuilderSupplier;

    public static AttributesBuilder newAttributesBuilder() {
        if (attributesBuilderSupplier == null) {
            return Attributes.builder();
        }
        return attributesBuilderSupplier.get().put("protocol_type", "remoting");
    }

    public static void initMetrics(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier) {
        RemotingMetricsManager.attributesBuilderSupplier = attributesBuilderSupplier;
        rpcLatency = meter.histogramBuilder("rocketmq_rpc_latency").setDescription("Rpc latency").setUnit("milliseconds").ofLongs().build();
    }

    public static String getWriteAndFlushResult(Future<?> future) {
        String result = "success";
        if (future.isCancelled()) {
            result = "cancelled";
        } else if (!future.isSuccess()) {
            result = "write_channel_failed";
        }
        return result;
    }

    public static String getRequestCodeDesc(int code) {
        return RemotingMetricsConstant.REQUEST_CODE_MAP.getOrDefault(code, String.valueOf(code));
    }

    public static String getResponseCodeDesc(int code) {
        return RemotingMetricsConstant.RESPONSE_CODE_MAP.getOrDefault(code, String.valueOf(code));
    }
}

