/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.MomentStatsItem;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MomentStatsItemSet {
    private final ConcurrentMap<String, MomentStatsItem> statsItemTable = new ConcurrentHashMap<String, MomentStatsItem>(128);
    private final String statsName;
    private final ScheduledExecutorService scheduledExecutorService;
    private final InternalLogger log;

    public MomentStatsItemSet(String statsName, ScheduledExecutorService scheduledExecutorService, InternalLogger log) {
        this.statsName = statsName;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = log;
        this.init();
    }

    public ConcurrentMap<String, MomentStatsItem> getStatsItemTable() {
        return this.statsItemTable;
    }

    public String getStatsName() {
        return this.statsName;
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    MomentStatsItemSet.this.printAtMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextMinutesTimeMillis() - System.currentTimeMillis()), 300000L, TimeUnit.MILLISECONDS);
    }

    private void printAtMinutes() {
        Iterator it = this.statsItemTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            MomentStatsItem momentStatsItem = (MomentStatsItem)next.getValue();
            if (momentStatsItem.getValue().get() == 0L) {
                it.remove();
                continue;
            }
            momentStatsItem.printAtMinutes();
            momentStatsItem.getValue().set(0L);
        }
    }

    public void setValue(String statsKey, int value) {
        MomentStatsItem statsItem = this.getAndCreateStatsItem(statsKey);
        statsItem.getValue().set(value);
    }

    public MomentStatsItem getAndCreateStatsItem(String statsKey) {
        MomentStatsItem prev;
        MomentStatsItem statsItem = (MomentStatsItem)this.statsItemTable.get(statsKey);
        if (null != statsItem || null == (prev = this.statsItemTable.put(statsKey, statsItem = new MomentStatsItem(this.statsName, statsKey, this.scheduledExecutorService, this.log)))) {
            // empty if block
        }
        return statsItem;
    }
}

