/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.QueryResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.Validators;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.CheckForbiddenContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.CheckForbiddenHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.SendMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.SendMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.ClientRemotingProcessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.CommunicationMode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.MQClientManager;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.MQProducerInner;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.MQFaultStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.Resolver;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.ServiceDetector;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.ordermessage.OrderMessageHandler;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionExecuter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.MessageQueueSelector;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionSendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.DefaultProducerRetryStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.RetryPlan;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.RetryStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.BoundaryType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ServiceState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.help.FAQUrl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageBatch;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageClientIDSetter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageDecoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageId;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.CheckTransactionStateRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.EndTransactionRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.SendMessageRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.com.google.common.base.Optional;
import com.aliyun.openservices.shade.com.google.common.base.Preconditions;
import com.aliyun.openservices.shade.com.google.common.base.Stopwatch;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultMQProducerImpl
implements MQProducerInner {
    private final InternalLogger log = ClientLogger.getLog();
    private final DefaultMQProducer defaultMQProducer;
    private final ConcurrentMap<String, TopicPublishInfo> topicPublishInfoTable = new ConcurrentHashMap<String, TopicPublishInfo>();
    private final ArrayList<SendMessageHook> sendMessageHookList = new ArrayList();
    private final RPCHook rpcHook;
    protected BlockingQueue<Runnable> checkRequestQueue;
    protected ExecutorService checkExecutor;
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private MQClientInstance mQClientFactory;
    private final ArrayList<CheckForbiddenHook> checkForbiddenHookList = new ArrayList();
    private int zipCompressLevel = Integer.parseInt(System.getProperty("rocketmq.message.compressLevel", "5"));
    private EventLoopGroup eventLoopGroup;
    private EventExecutorGroup eventExecutorGroup;
    private final MQFaultStrategy mqFaultStrategy;
    private volatile boolean offline = false;
    private ClientRemotingProcessor clientRemotingProcessor;
    private RetryStrategy retryStrategy;

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer) {
        this(defaultMQProducer, null);
    }

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer, RPCHook rpcHook) {
        this(defaultMQProducer, rpcHook, null, new DefaultProducerRetryStrategy());
    }

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer, RPCHook rpcHook, ClientRemotingProcessor clientRemotingProcessor) {
        this(defaultMQProducer, rpcHook, clientRemotingProcessor, new DefaultProducerRetryStrategy());
    }

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer, RPCHook rpcHook, ClientRemotingProcessor clientRemotingProcessor, RetryStrategy retryStrategy) {
        this.defaultMQProducer = defaultMQProducer;
        this.rpcHook = rpcHook;
        this.clientRemotingProcessor = clientRemotingProcessor;
        this.retryStrategy = retryStrategy;
        ServiceDetector serviceDetector = new ServiceDetector(){

            @Override
            public boolean detect(String endpoint, long timeoutMillis) {
                Optional candidateTopic = DefaultMQProducerImpl.this.pickTopic();
                if (!candidateTopic.isPresent()) {
                    return false;
                }
                try {
                    MessageQueue mq = new MessageQueue((String)candidateTopic.get(), null, 0);
                    DefaultMQProducerImpl.this.mQClientFactory.getMQClientAPIImpl().getMaxOffset(endpoint, mq, false, timeoutMillis);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        this.mqFaultStrategy = new MQFaultStrategy(defaultMQProducer.cloneClientConfig(), new Resolver(){

            @Override
            public String resolve(String name) {
                return DefaultMQProducerImpl.this.mQClientFactory.findBrokerAddressInPublish(name);
            }
        }, serviceDetector);
    }

    private Optional<String> pickTopic() {
        if (this.topicPublishInfoTable.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(this.topicPublishInfoTable.keySet().iterator().next());
    }

    public void registerCheckForbiddenHook(CheckForbiddenHook checkForbiddenHook) {
        this.checkForbiddenHookList.add(checkForbiddenHook);
        this.log.info("register a new checkForbiddenHook. hookName={}, allHookSize={}", (Object)checkForbiddenHook.hookName(), (Object)this.checkForbiddenHookList.size());
    }

    public void initTransactionEnv() {
        TransactionMQProducer producer = (TransactionMQProducer)this.defaultMQProducer;
        if (producer.getExecutorService() != null) {
            this.checkExecutor = producer.getExecutorService();
        } else {
            this.checkRequestQueue = new LinkedBlockingQueue<Runnable>(producer.getCheckRequestHoldMax());
            this.checkExecutor = new ThreadPoolExecutor(producer.getCheckThreadPoolMinSize(), producer.getCheckThreadPoolMaxSize(), 60000L, TimeUnit.MILLISECONDS, this.checkRequestQueue);
        }
    }

    public void destroyTransactionEnv() {
        if (this.checkExecutor != null) {
            this.checkExecutor.shutdown();
        }
        if (this.checkRequestQueue != null) {
            this.checkRequestQueue.clear();
        }
    }

    public void registerSendMessageHook(SendMessageHook hook) {
        this.sendMessageHookList.add(hook);
        this.log.info("register sendMessage Hook, {}", (Object)hook.hookName());
    }

    public void start() throws MQClientException {
        this.start(true);
    }

    public void start(boolean startFactory) throws MQClientException {
        switch (this.serviceState) {
            case CREATE_JUST: {
                this.serviceState = ServiceState.START_FAILED;
                this.checkConfig();
                if (!this.defaultMQProducer.getProducerGroup().equals("CLIENT_INNER_PRODUCER")) {
                    this.defaultMQProducer.changeInstanceNameToPID();
                }
                this.mQClientFactory = MQClientManager.getInstance().getAndCreateMQClientInstance(this.defaultMQProducer, this.rpcHook, this.eventLoopGroup, this.eventExecutorGroup, this.clientRemotingProcessor);
                boolean registerOK = this.mQClientFactory.registerProducer(this.defaultMQProducer.getProducerGroup(), this);
                if (!registerOK) {
                    this.serviceState = ServiceState.CREATE_JUST;
                    throw new MQClientException("The producer group[" + this.defaultMQProducer.getProducerGroup() + "] has been created before, specify another name please." + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
                }
                this.topicPublishInfoTable.put(this.defaultMQProducer.getCreateTopicKey(), new TopicPublishInfo());
                if (startFactory) {
                    this.mQClientFactory.start();
                }
                if (this.mqFaultStrategy.isStartDetectorEnable()) {
                    this.mqFaultStrategy.startDetector();
                }
                this.log.info("the producer [{}] start OK. sendMessageWithVIPChannel={}", (Object)this.defaultMQProducer.getProducerGroup(), (Object)this.defaultMQProducer.isSendMessageWithVIPChannel());
                this.serviceState = ServiceState.RUNNING;
                break;
            }
            case RUNNING: 
            case START_FAILED: 
            case SHUTDOWN_ALREADY: {
                throw new MQClientException("The producer service state not OK, maybe started once, " + (Object)((Object)this.serviceState) + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
            }
        }
        this.mQClientFactory.sendHeartbeatToAllBrokerWithLock();
    }

    private void checkConfig() throws MQClientException {
        Validators.checkGroup(this.defaultMQProducer.getProducerGroup());
        if (null == this.defaultMQProducer.getProducerGroup()) {
            throw new MQClientException("producerGroup is null", null);
        }
        if (this.defaultMQProducer.getProducerGroup().equals("DEFAULT_PRODUCER")) {
            throw new MQClientException("producerGroup can not equal DEFAULT_PRODUCER, please specify another one.", null);
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean shutdownFactory) {
        switch (this.serviceState) {
            case CREATE_JUST: {
                break;
            }
            case RUNNING: {
                this.mQClientFactory.unregisterProducer(this.defaultMQProducer.getProducerGroup());
                if (shutdownFactory) {
                    this.mQClientFactory.shutdown();
                }
                if (this.mqFaultStrategy.isStartDetectorEnable()) {
                    this.mqFaultStrategy.shutdown();
                }
                this.log.info("the producer [{}] shutdown OK", (Object)this.defaultMQProducer.getProducerGroup());
                this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                break;
            }
            case SHUTDOWN_ALREADY: {
                break;
            }
        }
    }

    @Override
    public Set<String> getPublishTopicList() {
        HashSet<String> topicList = new HashSet<String>();
        for (String key : this.topicPublishInfoTable.keySet()) {
            topicList.add(key);
        }
        return topicList;
    }

    @Override
    public boolean isPublishTopicNeedUpdate(String topic) {
        TopicPublishInfo prev = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        return null == prev || !prev.ok();
    }

    @Override
    public TransactionCheckListener checkListener() {
        if (this.defaultMQProducer instanceof TransactionMQProducer) {
            TransactionMQProducer producer = (TransactionMQProducer)this.defaultMQProducer;
            return producer.getTransactionCheckListener();
        }
        return null;
    }

    @Override
    public void checkTransactionState(final String addr, final MessageExt msg, final CheckTransactionStateRequestHeader header) {
        Runnable request = new Runnable(){
            private final String brokerAddr;
            private final MessageExt message;
            private final CheckTransactionStateRequestHeader checkRequestHeader;
            private final String group;
            {
                this.brokerAddr = addr;
                this.message = msg;
                this.checkRequestHeader = header;
                this.group = DefaultMQProducerImpl.this.defaultMQProducer.getProducerGroup();
            }

            @Override
            public void run() {
                TransactionCheckListener transactionCheckListener = DefaultMQProducerImpl.this.checkListener();
                if (transactionCheckListener != null) {
                    LocalTransactionState localTransactionState = LocalTransactionState.UNKNOW;
                    Throwable exception = null;
                    try {
                        localTransactionState = transactionCheckListener.checkLocalTransactionState(this.message);
                    }
                    catch (Throwable e) {
                        DefaultMQProducerImpl.this.log.error("Broker call checkTransactionState, but checkLocalTransactionState exception", e);
                        exception = e;
                    }
                    if (localTransactionState == null) {
                        localTransactionState = LocalTransactionState.UNKNOW;
                    }
                    this.processTransactionState(localTransactionState, this.group, exception);
                } else {
                    DefaultMQProducerImpl.this.log.warn("checkTransactionState, pick transactionCheckListener by group[{}] failed", (Object)this.group);
                }
            }

            private void processTransactionState(LocalTransactionState localTransactionState, String producerGroup, Throwable exception) {
                EndTransactionRequestHeader thisHeader = new EndTransactionRequestHeader();
                thisHeader.setCommitLogOffset(this.checkRequestHeader.getCommitLogOffset());
                thisHeader.setProducerGroup(producerGroup);
                thisHeader.setTranStateTableOffset(this.checkRequestHeader.getTranStateTableOffset());
                thisHeader.setFromTransactionCheck(true);
                thisHeader.setBrokerName(this.checkRequestHeader.getBrokerName());
                String uniqueKey = this.message.getProperties().get("UNIQ_KEY");
                if (uniqueKey == null) {
                    uniqueKey = this.message.getMsgId();
                }
                thisHeader.setMsgId(uniqueKey);
                thisHeader.setTransactionId(this.checkRequestHeader.getTransactionId());
                switch (localTransactionState) {
                    case COMMIT_MESSAGE: {
                        thisHeader.setCommitOrRollback(8);
                        break;
                    }
                    case ROLLBACK_MESSAGE: {
                        thisHeader.setCommitOrRollback(12);
                        DefaultMQProducerImpl.this.log.warn("when broker check, client rollback this transaction, {}", (Object)thisHeader);
                        break;
                    }
                    case UNKNOW: {
                        thisHeader.setCommitOrRollback(0);
                        DefaultMQProducerImpl.this.log.warn("when broker check, client does not know this transaction state, {}", (Object)thisHeader);
                        break;
                    }
                }
                String remark = null;
                if (exception != null) {
                    remark = "checkLocalTransactionState Exception: " + RemotingHelper.exceptionSimpleDesc(exception);
                }
                try {
                    DefaultMQProducerImpl.this.mQClientFactory.getMQClientAPIImpl().endTransactionOneway(this.brokerAddr, thisHeader, remark, 3000L);
                }
                catch (Exception e) {
                    DefaultMQProducerImpl.this.log.error("endTransactionOneway exception", e);
                }
            }
        };
        this.checkExecutor.submit(request);
    }

    @Override
    public TopicPublishInfo getTopicPublishInfo(String topic) {
        Preconditions.checkNotNull(topic);
        TopicPublishInfo info = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        return info;
    }

    @Override
    public void updateTopicPublishInfo(String topic, TopicPublishInfo info) {
        TopicPublishInfo prev;
        if (info != null && topic != null && (prev = this.topicPublishInfoTable.put(topic, info)) != null) {
            this.log.info("updateTopicPublishInfo prev is not null, " + prev.toString());
        }
    }

    public void detectByOneRound() {
        this.mqFaultStrategy.detectByOneRound();
    }

    @Override
    public void removeTopicPublishInfo(String topic) {
        if (!this.defaultMQProducer.isAutoCleanTopicRouteNotFound()) {
            return;
        }
        TopicPublishInfo prev = (TopicPublishInfo)this.topicPublishInfoTable.remove(topic);
        if (prev != null) {
            this.log.info("removeTopicPublishInfo {}, {}, {}", this.defaultMQProducer.getProducerGroup(), topic, prev);
        }
    }

    @Override
    public boolean isUnitMode() {
        return this.defaultMQProducer.isUnitMode();
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public void offline() {
        boolean changed = !this.offline;
        this.offline = true;
        if (this.getServiceState() == ServiceState.RUNNING && changed) {
            this.getmQClientFactory().offlineProducer(this.defaultMQProducer.getProducerGroup());
        }
    }

    @Override
    public void online() {
        this.offline = false;
    }

    public void createTopic(String key, String newTopic, int queueNum) throws MQClientException {
        this.createTopic(key, newTopic, queueNum, 0);
    }

    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag) throws MQClientException {
        this.makeSureStateOK();
        Validators.checkTopic(newTopic);
        this.mQClientFactory.getMQAdminImpl().createTopic(key, newTopic, queueNum, topicSysFlag);
    }

    private void makeSureStateOK() throws MQClientException {
        if (this.serviceState != ServiceState.RUNNING) {
            throw new MQClientException("The producer service state not OK, " + (Object)((Object)this.serviceState) + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
        }
    }

    public List<MessageQueue> fetchPublishMessageQueues(String topic) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().fetchPublishMessageQueues(topic);
    }

    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        return this.searchOffset(mq, timestamp, BoundaryType.LOWER);
    }

    public long searchOffset(MessageQueue mq, long timestamp, BoundaryType boundaryType) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().searchOffset(mq, timestamp, boundaryType);
    }

    public long maxOffset(MessageQueue mq) throws MQClientException {
        return this.maxOffset(mq, true);
    }

    public long maxOffset(MessageQueue mq, boolean committed) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().maxOffset(mq, committed);
    }

    public long minOffset(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().minOffset(mq);
    }

    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().earliestMsgStoreTime(mq);
    }

    public MessageExt viewMessage(String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().viewMessage(msgId);
    }

    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessage(topic, key, maxNum, begin, end);
    }

    public MessageExt queryMessageByUniqKey(String topic, String uniqKey) throws MQClientException, InterruptedException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessageByUniqKey(topic, uniqKey);
    }

    public void send(Message msg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, sendCallback, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public void send(Message msg, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendDefaultImpl(msg, CommunicationMode.ASYNC, sendCallback, timeout);
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public MessageQueue selectOneMessageQueue(TopicPublishInfo tpInfo, String lastBrokerName, boolean resetIndex) {
        boolean remoteFaultTolerance = this.mQClientFactory.getRemoteClientConfig().getRemoteFaultTolerance();
        return this.mqFaultStrategy.selectOneMessageQueue(tpInfo, lastBrokerName, remoteFaultTolerance, resetIndex);
    }

    public void updateFaultItem(String brokerName, long currentLatency, boolean isolation, boolean reachable) {
        this.mqFaultStrategy.updateFaultItem(brokerName, currentLatency, isolation, reachable);
    }

    private SendResult sendDefaultImpl(Message msg, CommunicationMode communicationMode, SendCallback sendCallback, long timeout) throws InterruptedException, RemotingException, MQClientException, MQBrokerException {
        return this.sendDefaultImpl(msg, communicationMode, sendCallback, timeout, null, null);
    }

    private SendResult sendDefaultImpl(Message msg, CommunicationMode communicationMode, SendCallback sendCallback, long timeout, Integer sendTimesTotal, String initLastBrokerName) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginTimestampFirst;
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        Random random = new Random();
        long invokeId = random.nextLong();
        long beginTimestampPrev = beginTimestampFirst = System.currentTimeMillis();
        RetryStrategy retry = this.retryStrategy == null ? null : this.retryStrategy.clone();
        TopicPublishInfo topicPublishInfo = this.tryToFindTopicPublishInfo(msg.getTopic());
        if (topicPublishInfo != null && topicPublishInfo.ok()) {
            int times;
            MessageQueue mq = null;
            Exception exception = null;
            SendResult sendResult = null;
            int timesTotal = sendTimesTotal == null ? this.getSendTimesTotal(communicationMode) : sendTimesTotal.intValue();
            Object[] brokersSent = new String[timesTotal];
            int responseCode = -1;
            boolean resetIndex = false;
            for (times = 0; times < timesTotal; ++times) {
                long endTimestamp;
                MessageQueue mqSelected;
                String lastBrokerName;
                String string = lastBrokerName = null == mq ? initLastBrokerName : mq.getBrokerName();
                if (times > 0) {
                    resetIndex = true;
                }
                if ((mqSelected = this.selectOneMessageQueue(topicPublishInfo, lastBrokerName, resetIndex)) == null) break;
                mq = mqSelected;
                brokersSent[times] = mq.getBrokerName();
                long timeoutPerSend = this.getTimeoutPerSend(timeout, timesTotal, times);
                try {
                    beginTimestampPrev = System.currentTimeMillis();
                    if (times > 0) {
                        msg.setTopic(this.defaultMQProducer.withNamespace(msg.getTopic()));
                    }
                    sendResult = this.sendKernelImpl(msg, mq, communicationMode, sendCallback, topicPublishInfo, timeoutPerSend);
                    endTimestamp = System.currentTimeMillis();
                    this.updateFaultItem(mq.getBrokerName(), endTimestamp - beginTimestampPrev, false, true);
                    switch (communicationMode) {
                        case ASYNC: {
                            return null;
                        }
                        case ONEWAY: {
                            return null;
                        }
                        case SYNC: {
                            if (sendResult.getSendStatus() != SendStatus.SEND_OK && this.defaultMQProducer.isRetryAnotherBrokerWhenNotStoreOK()) break;
                            return sendResult;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    endTimestamp = System.currentTimeMillis();
                    exception = e;
                    long latency = endTimestamp - beginTimestampPrev;
                    responseCode = this.processSendException(e, mq.getBrokerName(), latency);
                    if (responseCode == 17) break;
                    this.doRetryPolicy(invokeId, retry, mq, times, e, latency);
                }
            }
            if (sendResult != null) {
                return sendResult;
            }
            String info = String.format("Send [%d] times, still failed, invokeId: %d, cost [%d]ms, topic: %s, brokersSent: %s", times, invokeId, System.currentTimeMillis() - beginTimestampFirst, msg.getTopic(), Arrays.toString(brokersSent));
            info = info + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/");
            MQClientException mqClientException = new MQClientException(info, exception);
            mqClientException.setResponseCode(responseCode);
            throw mqClientException;
        }
        List<String> nsList = this.getmQClientFactory().getMQClientAPIImpl().getNameServerAddressList();
        if (null == nsList || nsList.isEmpty()) {
            throw new MQClientException("No name server address, please set it." + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null).setResponseCode(10004);
        }
        throw new MQClientException("No route info of this topic, " + msg.getTopic() + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null).setResponseCode(10005);
    }

    private TopicPublishInfo tryToFindTopicPublishInfo(String topic) throws MQClientException {
        TopicPublishInfo topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        if (null == topicPublishInfo || !topicPublishInfo.ok()) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(topic);
            topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        }
        if (topicPublishInfo != null && (topicPublishInfo.isHaveTopicRouterInfo() || topicPublishInfo.ok())) {
            return topicPublishInfo;
        }
        if (this.defaultMQProducer.isUseDefaultTopicIfNotFound()) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(topic, true, this.defaultMQProducer);
            topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
            return topicPublishInfo;
        }
        throw new MQClientException(17, "Topic " + topic + " not exist!");
    }

    private SendResult sendKernelImpl(Message msg, MessageQueue mq, CommunicationMode communicationMode, SendCallback sendCallback, TopicPublishInfo topicPublishInfo, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.tryToFindTopicPublishInfo(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        SendMessageContext context = null;
        if (brokerAddr != null) {
            brokerAddr = MixAll.brokerVIPChannel(this.defaultMQProducer.isSendMessageWithVIPChannel(), brokerAddr);
            byte[] prevBody = msg.getBody();
            try {
                String tranMsg;
                if (!(msg instanceof MessageBatch)) {
                    MessageClientIDSetter.setUniqID(msg);
                    if (this.defaultMQProducer.isAddExtendUniqInfo()) {
                        MessageClientIDSetter.setExtendUniqInfo(msg, this.defaultMQProducer.getRandomSign());
                    }
                }
                boolean topicWithNamespace = false;
                if (null != this.mQClientFactory.getClientConfig().getNamespace()) {
                    msg.setInstanceId(this.mQClientFactory.getClientConfig().getNamespace());
                    topicWithNamespace = true;
                }
                int sysFlag = 0;
                boolean msgBodyCompressed = false;
                if (this.tryToCompressMessage(msg)) {
                    sysFlag |= 1;
                    msgBodyCompressed = true;
                }
                if ((tranMsg = msg.getProperty("TRAN_MSG")) != null && Boolean.parseBoolean(tranMsg)) {
                    sysFlag |= 4;
                }
                if (this.hasCheckForbiddenHook()) {
                    CheckForbiddenContext checkForbiddenContext = new CheckForbiddenContext();
                    checkForbiddenContext.setNameSrvAddr(this.defaultMQProducer.getNamesrvAddr());
                    checkForbiddenContext.setGroup(this.defaultMQProducer.getProducerGroup());
                    checkForbiddenContext.setCommunicationMode(communicationMode);
                    checkForbiddenContext.setBrokerAddr(brokerAddr);
                    checkForbiddenContext.setMessage(msg);
                    checkForbiddenContext.setMq(mq);
                    checkForbiddenContext.setUnitMode(this.isUnitMode());
                    this.executeCheckForbiddenHook(checkForbiddenContext);
                }
                if (this.hasSendMessageHook()) {
                    context = new SendMessageContext();
                    context.setProducer(this);
                    context.setProducerGroup(this.defaultMQProducer.getProducerGroup());
                    context.setCommunicationMode(communicationMode);
                    context.setBornHost(this.defaultMQProducer.getClientIP());
                    context.setBrokerAddr(brokerAddr);
                    context.setMessage(msg);
                    context.setMq(mq);
                    context.setNamespace(this.defaultMQProducer.getNamespace());
                    String isTrans = msg.getProperty("TRAN_MSG");
                    if (isTrans != null && isTrans.equals("true")) {
                        context.setMsgType(MessageType.Trans_Msg_Half);
                    }
                    if (msg.getProperty("__STARTDELIVERTIME") != null || msg.getProperty("DELAY") != null) {
                        context.setMsgType(MessageType.Delay_Msg);
                    }
                    this.executeSendMessageHookBefore(context);
                }
                SendMessageRequestHeader requestHeader = new SendMessageRequestHeader();
                requestHeader.setProducerGroup(this.defaultMQProducer.getProducerGroup());
                requestHeader.setTopic(msg.getTopic());
                requestHeader.setDefaultTopic(this.defaultMQProducer.getCreateTopicKey());
                requestHeader.setDefaultTopicQueueNums(this.defaultMQProducer.getDefaultTopicQueueNums());
                requestHeader.setQueueId(mq.getQueueId());
                requestHeader.setSysFlag(sysFlag);
                requestHeader.setBornTimestamp(System.currentTimeMillis());
                requestHeader.setFlag(msg.getFlag());
                requestHeader.setProperties(MessageDecoder.messageProperties2String(msg.getProperties()));
                requestHeader.setReconsumeTimes(0);
                requestHeader.setUnitMode(this.isUnitMode());
                requestHeader.setBatch(msg instanceof MessageBatch);
                requestHeader.setBrokerName(mq.getBrokerName());
                if (requestHeader.getTopic().startsWith("%RETRY%")) {
                    String maxReconsumeTimes;
                    String reconsumeTimes = MessageAccessor.getReconsumeTime(msg);
                    if (reconsumeTimes != null) {
                        requestHeader.setReconsumeTimes(Integer.valueOf(reconsumeTimes));
                    }
                    if ((maxReconsumeTimes = MessageAccessor.getMaxReconsumeTimes(msg)) != null) {
                        requestHeader.setMaxReconsumeTimes(Integer.valueOf(maxReconsumeTimes));
                    }
                }
                SendResult sendResult = null;
                switch (communicationMode) {
                    case ASYNC: {
                        Message tmpMessage = msg;
                        boolean messageCloned = false;
                        if (msgBodyCompressed) {
                            tmpMessage = MessageAccessor.cloneMessage(msg);
                            messageCloned = true;
                            msg.setBody(prevBody);
                        }
                        if (topicWithNamespace) {
                            if (!messageCloned) {
                                tmpMessage = MessageAccessor.cloneMessage(msg);
                                messageCloned = true;
                            }
                            msg.setTopic(NamespaceUtil.withoutNamespace(msg.getTopic(), this.defaultMQProducer.getNamespace()));
                        }
                        sendResult = this.mQClientFactory.getMQClientAPIImpl().sendMessage(brokerAddr, mq.getBrokerName(), tmpMessage, requestHeader, timeout, communicationMode, sendCallback, topicPublishInfo, this.mQClientFactory, this.defaultMQProducer.getRetryTimesWhenSendAsyncFailed(), context, this);
                        break;
                    }
                    case ONEWAY: 
                    case SYNC: {
                        sendResult = this.mQClientFactory.getMQClientAPIImpl().sendMessage(brokerAddr, mq.getBrokerName(), msg, requestHeader, timeout, communicationMode, context, this);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.hasSendMessageHook()) {
                    context.setSendResult(sendResult);
                    this.executeSendMessageHookAfter(context);
                }
                SendResult sendResult2 = sendResult;
                return sendResult2;
            }
            catch (RemotingException e) {
                if (this.hasSendMessageHook()) {
                    context.setException(e);
                    this.executeSendMessageHookAfter(context);
                }
                throw e;
            }
            catch (MQBrokerException e) {
                if (this.hasSendMessageHook()) {
                    context.setException(e);
                    this.executeSendMessageHookAfter(context);
                }
                throw e;
            }
            catch (InterruptedException e) {
                if (this.hasSendMessageHook()) {
                    context.setException(e);
                    this.executeSendMessageHookAfter(context);
                }
                throw e;
            }
            finally {
                msg.setBody(prevBody);
                msg.setTopic(NamespaceUtil.withoutNamespace(msg.getTopic(), this.defaultMQProducer.getNamespace()));
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public MQClientInstance getmQClientFactory() {
        return this.mQClientFactory;
    }

    private boolean tryToCompressMessage(Message msg) {
        if (msg instanceof MessageBatch) {
            return false;
        }
        byte[] body = msg.getBody();
        if (body != null && body.length >= this.defaultMQProducer.getCompressMsgBodyOverHowmuch()) {
            try {
                byte[] data = UtilAll.compress(body, this.zipCompressLevel);
                if (data != null) {
                    msg.setBody(data);
                    return true;
                }
            }
            catch (IOException e) {
                this.log.error("tryToCompressMessage exception", e);
                this.log.warn(msg.toString());
            }
        }
        return false;
    }

    public boolean hasCheckForbiddenHook() {
        return !this.checkForbiddenHookList.isEmpty();
    }

    public void executeCheckForbiddenHook(CheckForbiddenContext context) throws MQClientException {
        if (this.hasCheckForbiddenHook()) {
            for (CheckForbiddenHook hook : this.checkForbiddenHookList) {
                hook.checkForbidden(context);
            }
        }
    }

    public boolean hasSendMessageHook() {
        return !this.sendMessageHookList.isEmpty();
    }

    public void executeSendMessageHookBefore(SendMessageContext context) {
        if (!this.sendMessageHookList.isEmpty()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    hook.sendMessageBefore(context);
                }
                catch (Throwable e) {
                    this.log.warn("failed to executeSendMessageHookBefore", e);
                }
            }
        }
    }

    public void executeSendMessageHookAfter(SendMessageContext context) {
        if (!this.sendMessageHookList.isEmpty()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    hook.sendMessageAfter(context);
                }
                catch (Throwable e) {
                    this.log.warn("failed to executeSendMessageHookAfter", e);
                }
            }
        }
    }

    public void sendOneway(Message msg) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendDefaultImpl(msg, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public SendResult send(Message msg, MessageQueue mq) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, mq, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        if (!msg.getTopic().equals(mq.getTopic())) {
            throw new MQClientException("message's topic not equal mq's topic", null);
        }
        return this.sendKernelImpl(msg, mq, CommunicationMode.SYNC, null, null, timeout);
    }

    public void send(Message msg, MessageQueue mq, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, mq, sendCallback, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public void send(Message msg, MessageQueue mq, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        if (!msg.getTopic().equals(mq.getTopic())) {
            throw new MQClientException("message's topic not equal mq's topic", null);
        }
        try {
            this.sendKernelImpl(msg, mq, CommunicationMode.ASYNC, sendCallback, null, timeout);
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public void sendOneway(Message msg, MessageQueue mq) throws MQClientException, RemotingException, InterruptedException {
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        try {
            this.sendKernelImpl(msg, mq, CommunicationMode.ONEWAY, null, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public SendResult send(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, selector, arg, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.sendSelectImpl(msg, selector, arg, CommunicationMode.SYNC, null, timeout);
    }

    private SendResult sendSelectImpl(Message msg, MessageQueueSelector selector, Object arg, CommunicationMode communicationMode, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        Random random = new Random();
        long invokeId = random.nextLong();
        RetryStrategy retry = this.retryStrategy == null ? null : this.retryStrategy.clone();
        TopicPublishInfo info = this.tryToFindTopicPublishInfo(msg.getTopic());
        if (info != null && info.ok()) {
            MessageQueue mq = null;
            Message userMessage = MessageAccessor.cloneMessage(msg);
            String userTopic = NamespaceUtil.withoutNamespace(userMessage.getTopic(), this.mQClientFactory.getClientConfig().getNamespace());
            userMessage.setTopic(userTopic);
            if (info.isHAOrderTopic()) {
                int sendTimes;
                String topicName = msg.getTopic();
                OrderMessageHandler handler = new OrderMessageHandler(this.mQClientFactory, topicName, info, this.mqFaultStrategy);
                handler.updateFromTopicPublishInfoChange();
                List<MessageQueue> messageQueueList = handler.generatePublishMessageQueueList();
                int sendTimesTotal = this.getSendTimesTotal(communicationMode);
                String lastBrokerName = null;
                Stopwatch watcher = Stopwatch.createUnstarted();
                Exception exceptionRetrieved = null;
                int responseCode = -1;
                for (sendTimes = 0; sendTimes < sendTimesTotal; ++sendTimes) {
                    try {
                        MessageQueue selectedMQ = handler.selectOneMessageQueue(selector.select(messageQueueList, userMessage, arg), lastBrokerName);
                        mq = this.mQClientFactory.getClientConfig().queueWithNamespace(selectedMQ);
                    }
                    catch (Throwable e) {
                        throw new MQClientException("select message queue exception.", e);
                    }
                    if (mq != null && mq.getQueueId() != -1) {
                        try {
                            handler.writeMQOffsetToMessage(mq.getTopic(), mq.getQueueGroupId(), msg);
                            lastBrokerName = mq.getBrokerName();
                            long timeoutPerSend = this.getTimeoutPerSend(timeout, sendTimesTotal, sendTimes);
                            if (sendTimes > 0) {
                                msg.setTopic(this.defaultMQProducer.withNamespace(msg.getTopic()));
                            }
                            watcher.reset().start();
                            SendResult result = this.sendKernelImpl(msg, mq, communicationMode, sendCallback, null, timeoutPerSend);
                            long latency = watcher.stop().elapsed(TimeUnit.MILLISECONDS);
                            this.updateFaultItem(lastBrokerName, latency, false, true);
                            if (!handler.processSendResult(result, communicationMode, mq)) {
                                return result;
                            }
                        }
                        catch (Exception e) {
                            exceptionRetrieved = e;
                            long latency = watcher.stop().elapsed(TimeUnit.MILLISECONDS);
                            responseCode = this.processSendException(e, mq.getBrokerName(), latency);
                            if (responseCode == 17) {
                                this.log.warn(String.format("Send exception, topic %s not exists", topicName));
                                break;
                            }
                            this.doRetryPolicy(invokeId, retry, mq, sendTimes, e, latency);
                        }
                        continue;
                    }
                    String messageQueueInfo = mq != null ? mq.toString() : "";
                    throw new MQClientException(String.format("MessageQueue error, info: %s, topic: %s", messageQueueInfo, msg.getTopic()), null);
                }
                int queueGroupId = mq != null ? mq.getQueueGroupId() : -1;
                String exceptionInfo = String.format("Send [%d] times, still failed, invokeId: %d, topic: %s, queueGroupId: %d", sendTimes, invokeId, msg.getTopic(), queueGroupId);
                MQClientException mqClientException = new MQClientException(exceptionInfo, exceptionRetrieved);
                mqClientException.setResponseCode(responseCode);
                throw mqClientException;
            }
            try {
                List<MessageQueue> messageQueueList = this.mQClientFactory.getMQAdminImpl().parsePublishMessageQueues(info.getMessageQueueList());
                mq = this.mQClientFactory.getClientConfig().queueWithNamespace(selector.select(messageQueueList, userMessage, arg));
            }
            catch (Throwable e) {
                throw new MQClientException("select message queue throwed exception.", e);
            }
            if (mq != null) {
                return this.sendKernelImpl(msg, mq, communicationMode, sendCallback, null, timeout);
            }
            throw new MQClientException("select message queue return null.", null);
        }
        throw new MQClientException("No route info for this topic, " + msg.getTopic(), null);
    }

    private void doRetryPolicy(long invokeId, RetryStrategy retry, MessageQueue mq, int sendTimes, Exception e, long latency) throws InterruptedException {
        if (this.defaultMQProducer.isEnableBackOffRetryStrategy() && retry != null) {
            RetryPlan retryPlan = retry.makeRetryDecision(e);
            if (retryPlan.isShouldRetry()) {
                this.log.info("Send failed, invokeId: {}, rt: {}ms, broker: {}, backoff: {}ms, cause: {}", invokeId, latency, mq.getBrokerName(), retryPlan.getBackoffMillis(), e.getMessage());
                Thread.sleep(retryPlan.getBackoffMillis());
            } else {
                this.log.info("Send failed, invokeId: {}, rt: {}ms, broker: {}, backoff over sendTimes:{}, cause: {}", invokeId, latency, mq.getBrokerName(), retry.getRetries(), e.getMessage());
            }
        } else {
            this.log.warn("Send failed, retry at once, invokeId: {}, rt: {}ms, broker: {}, send times: {}, cause: {}", invokeId, latency, mq.getBrokerName(), sendTimes + 1, e.getMessage());
        }
    }

    public void send(Message msg, MessageQueueSelector selector, Object arg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, selector, arg, sendCallback, this.defaultMQProducer.getSendMsgTimeout());
    }

    public void send(Message msg, MessageQueueSelector selector, Object arg, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendSelectImpl(msg, selector, arg, CommunicationMode.ASYNC, sendCallback, timeout);
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknownn exception", e);
        }
    }

    public void sendOneway(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendSelectImpl(msg, selector, arg, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public TransactionSendResult sendMessageInTransaction(Message msg, LocalTransactionExecuter tranExecuter, Object arg) throws MQClientException {
        if (null == tranExecuter) {
            throw new MQClientException("tranExecutor is null", null);
        }
        Validators.checkMessage(msg, this.defaultMQProducer);
        SendResult sendResult = null;
        MessageAccessor.putProperty(msg, "TRAN_MSG", "true");
        MessageAccessor.putProperty(msg, "PGROUP", this.defaultMQProducer.getProducerGroup());
        try {
            sendResult = this.send(msg);
        }
        catch (Exception e) {
            throw new MQClientException("send message Exception", e);
        }
        LocalTransactionState localTransactionState = LocalTransactionState.UNKNOW;
        Throwable localException = null;
        switch (sendResult.getSendStatus()) {
            case SEND_OK: {
                try {
                    if (sendResult.getTransactionId() != null) {
                        msg.putUserProperty("__transactionId__", sendResult.getTransactionId());
                    }
                    if (null == (localTransactionState = tranExecuter.executeLocalTransactionBranch(msg, arg))) {
                        localTransactionState = LocalTransactionState.UNKNOW;
                    }
                    if (localTransactionState == LocalTransactionState.COMMIT_MESSAGE) break;
                    this.log.info("executeLocalTransactionBranch return {}", (Object)localTransactionState);
                    this.log.info(msg.toString());
                }
                catch (Throwable e) {
                    this.log.info("executeLocalTransactionBranch exception", e);
                    this.log.info(msg.toString());
                    localException = e;
                }
                break;
            }
            case FLUSH_DISK_TIMEOUT: 
            case FLUSH_SLAVE_TIMEOUT: 
            case SLAVE_NOT_AVAILABLE: {
                localTransactionState = LocalTransactionState.ROLLBACK_MESSAGE;
                break;
            }
        }
        try {
            this.endTransaction(sendResult, localTransactionState, localException);
        }
        catch (Exception e) {
            this.log.warn("local transaction execute " + (Object)((Object)localTransactionState) + ", but end broker transaction failed", e);
        }
        TransactionSendResult transactionSendResult = new TransactionSendResult();
        transactionSendResult.setSendStatus(sendResult.getSendStatus());
        transactionSendResult.setMessageQueue(sendResult.getMessageQueue());
        transactionSendResult.setMsgId(sendResult.getMsgId());
        transactionSendResult.setQueueOffset(sendResult.getQueueOffset());
        transactionSendResult.setTransactionId(sendResult.getTransactionId());
        transactionSendResult.setLocalTransactionState(localTransactionState);
        if (localException != null) {
            transactionSendResult.setErrorMessage("executeLocalTransactionBranch error. " + localException.getMessage());
            transactionSendResult.setRuntimeException(new RuntimeException(localException));
        }
        return transactionSendResult;
    }

    public SendResult send(Message msg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, this.defaultMQProducer.getSendMsgTimeout(), null, null);
    }

    public SendResult send(Message msg, Integer sendTimesTotal, String initLastBrokerName) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, this.defaultMQProducer.getSendMsgTimeout(), sendTimesTotal, initLastBrokerName);
    }

    public void endTransaction(SendResult sendResult, LocalTransactionState localTransactionState, Throwable localException) throws RemotingException, MQBrokerException, InterruptedException, UnknownHostException {
        MessageId id = sendResult.getOffsetMsgId() != null ? MessageDecoder.decodeMessageId(sendResult.getOffsetMsgId()) : MessageDecoder.decodeMessageId(sendResult.getMsgId());
        String transactionId = sendResult.getTransactionId();
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(sendResult.getMessageQueue().getBrokerName());
        EndTransactionRequestHeader requestHeader = new EndTransactionRequestHeader();
        requestHeader.setTransactionId(transactionId);
        requestHeader.setCommitLogOffset(id.getOffset());
        requestHeader.setBrokerName(sendResult.getMessageQueue().getBrokerName());
        switch (localTransactionState) {
            case COMMIT_MESSAGE: {
                requestHeader.setCommitOrRollback(8);
                break;
            }
            case ROLLBACK_MESSAGE: {
                requestHeader.setCommitOrRollback(12);
                break;
            }
            case UNKNOW: {
                requestHeader.setCommitOrRollback(0);
                break;
            }
        }
        requestHeader.setProducerGroup(this.defaultMQProducer.getProducerGroup());
        requestHeader.setTranStateTableOffset(sendResult.getQueueOffset());
        requestHeader.setMsgId(sendResult.getMsgId());
        String remark = localException != null ? "executeLocalTransactionBranch exception: " + localException.toString() : null;
        this.mQClientFactory.getMQClientAPIImpl().endTransactionOneway(brokerAddr, requestHeader, remark, this.defaultMQProducer.getSendMsgTimeout());
    }

    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.mQClientFactory.getMQClientAPIImpl().getRemotingClient().setCallbackExecutor(callbackExecutor);
    }

    public SendResult send(Message msg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.sendDefaultImpl(msg, CommunicationMode.SYNC, null, timeout);
    }

    public SendResult send(Message msg, long timeout, Integer sendTimesTotal, String initLastBrokerName) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.sendDefaultImpl(msg, CommunicationMode.SYNC, null, timeout, sendTimesTotal, initLastBrokerName);
    }

    public ConcurrentMap<String, TopicPublishInfo> getTopicPublishInfoTable() {
        return this.topicPublishInfoTable;
    }

    public int getZipCompressLevel() {
        return this.zipCompressLevel;
    }

    public void setZipCompressLevel(int zipCompressLevel) {
        this.zipCompressLevel = zipCompressLevel;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState;
    }

    public long[] getNotAvailableDuration() {
        return this.mqFaultStrategy.getNotAvailableDuration();
    }

    public void setNotAvailableDuration(long[] notAvailableDuration) {
        this.mqFaultStrategy.setNotAvailableDuration(notAvailableDuration);
    }

    public long[] getLatencyMax() {
        return this.mqFaultStrategy.getLatencyMax();
    }

    public void setLatencyMax(long[] latencyMax) {
        this.mqFaultStrategy.setLatencyMax(latencyMax);
    }

    public boolean isSendLatencyFaultEnable() {
        return this.mqFaultStrategy.isSendLatencyFaultEnable();
    }

    public void setSendLatencyFaultEnable(boolean sendLatencyFaultEnable) {
        this.mqFaultStrategy.setSendLatencyFaultEnable(sendLatencyFaultEnable);
    }

    public void setIfStartDetector(boolean startDetectorEnable) {
        this.mqFaultStrategy.setStartDetectorEnable(startDetectorEnable);
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    public EventExecutorGroup getEventExecutorGroup() {
        return this.eventExecutorGroup;
    }

    public void setEventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
        this.eventExecutorGroup = eventExecutorGroup;
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }

    private int processSendException(Exception e, String brokerName, long latency) throws MQBrokerException, InterruptedException, MQClientException {
        int responseCode = -1;
        if (e instanceof RemotingException) {
            if (this.mqFaultStrategy.isStartDetectorEnable()) {
                this.updateFaultItem(brokerName, latency, true, false);
            } else {
                this.updateFaultItem(brokerName, latency, true, true);
            }
            if (e instanceof RemotingConnectException) {
                responseCode = 10001;
            }
            if (e instanceof RemotingTimeoutException) {
                responseCode = 10002;
            }
            return responseCode;
        }
        if (e instanceof MQClientException) {
            this.updateFaultItem(brokerName, latency, false, true);
            responseCode = 10003;
            return responseCode;
        }
        if (e instanceof MQBrokerException) {
            MQBrokerException brokerException = (MQBrokerException)e;
            responseCode = brokerException.getResponseCode();
            switch (brokerException.getResponseCode()) {
                case 17: 
                case 215: {
                    return responseCode;
                }
                case 1: 
                case 2: 
                case 14: 
                case 16: 
                case 204: 
                case 205: {
                    this.updateFaultItem(brokerName, latency, true, true);
                    return responseCode;
                }
            }
            throw brokerException;
        }
        if (e instanceof InterruptedException) {
            this.updateFaultItem(brokerName, latency, false, true);
            throw (InterruptedException)e;
        }
        this.log.warn("Send exception.", e);
        throw new MQClientException("Send exception.", e);
    }

    private int getSendTimesTotal(CommunicationMode mode) {
        if (mode == CommunicationMode.SYNC) {
            return 1 + this.defaultMQProducer.getRetryTimesWhenSendFailed();
        }
        return 1;
    }

    private long getTimeoutPerSend(long timeout, int sendTimesTotal, int sendAttempted) {
        if (timeout <= 0L) {
            timeout = 3000L;
        }
        long firstSendTimeout = (long)((double)timeout * 0.6);
        int retryTimesTotal = sendTimesTotal - 1;
        long remainTimeout = timeout - firstSendTimeout;
        if (sendAttempted == 0 || retryTimesTotal == 0) {
            return firstSendTimeout;
        }
        return remainTimeout / (long)retryTimesTotal;
    }
}

