/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.manager.util;

import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxRecord;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeExactlyOnceStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;

public class TxContextUtil {
    public static void updateTxContext(MQTxContext txContext) {
        if (txContext == null) {
            txContext = TxContextUtil.buildTxContext();
        }
        txContext.setInTxEnv(true);
        txContext.setAutoCommit(true);
    }

    public static MQTxContext buildTxContext() {
        MQTxContext txContext = new MQTxContext();
        txContext.setInTxEnv(true);
        txContext.setAutoCommit(true);
        return txContext;
    }

    public static MQTxRecord buildTxRecord(MQTxContext context) {
        MQTxRecord record = new MQTxRecord();
        record.setTopicName(context.getTopicName());
        record.setOffset(context.getOffset());
        record.setMessageId(context.getMessageId());
        record.setQid(context.getMessageQueue().getQueueId());
        record.setBrokerName(context.getMessageQueue().getBrokerName());
        record.setConsumerGroup(context.getConsumerGroup());
        record.setCreateTime(System.currentTimeMillis());
        return record;
    }

    public static boolean isTxContextCommitted(MQTxContext context) {
        if (context == null || context.getStage() == null) {
            return false;
        }
        return MQTxContext.TxStage.COMMIT == context.getStage() && MQTxContext.TxStatus.PROCESS_OK == context.getStatus();
    }

    public static boolean isTxContextRollbacked(MQTxContext context) {
        if (context == null) {
            return false;
        }
        return MQTxContext.TxStage.ROLLBACK == context.getStage() && MQTxContext.TxStatus.USER_PROCESS_FAIL == context.getStatus();
    }

    public static boolean isTxContextFinished(MQTxContext context) {
        if (context == null) {
            return false;
        }
        return MQTxContext.TxStage.COMMIT == context.getStage() && MQTxContext.TxStatus.PROCESS_OK == context.getStatus() || MQTxContext.TxStage.ROLLBACK == context.getStage() && MQTxContext.TxStatus.USER_PROCESS_FAIL == context.getStatus();
    }

    public static boolean isTxProcessed(MQTxContext context) {
        if (context == null) {
            return false;
        }
        return context.getStage() != null && context.getStatus() != null;
    }

    public static String buildInternalMsgId(MessageExt msg, String consumerGroup) {
        String uniqInfo = null;
        if (msg.getProperty("EXTEND_UNIQ_INFO") != null) {
            uniqInfo = msg.getProperty("EXTEND_UNIQ_INFO");
        } else if (msg.getMsgId() != null) {
            uniqInfo = msg.getMsgId();
        }
        return uniqInfo + "#" + consumerGroup;
    }

    public static ConsumeExactlyOnceStatus getExactlyOnceStatus(MQTxContext context) {
        if (!TxContextUtil.isTxProcessed(context)) {
            return ConsumeExactlyOnceStatus.NO_EXACTLYONCE;
        }
        if (context.isDup()) {
            return ConsumeExactlyOnceStatus.EXACTLYONCE_DEDUP;
        }
        return ConsumeExactlyOnceStatus.EXACTLYONCE_PASS;
    }
}

