/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.manager.util;

import com.aliyun.openservices.ons.api.exactlyonce.manager.TransactionManager;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.LogUtil;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.ReadOffsetType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ProcessQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class OffsetUtil {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();

    public static Long getMQSafeOffset(MessageQueue mq, String consumerGroup) {
        if (mq == null) {
            return null;
        }
        DefaultMQPushConsumer consumer = TransactionManager.getConsumer(consumerGroup).iterator().next();
        if (consumer == null) {
            return null;
        }
        long realOffset = -2L;
        try {
            Optional<Long> optionalOffset = consumer.getDefaultMQPushConsumerImpl().getOffsetStore().readOffset(mq, ReadOffsetType.READ_FROM_STORE);
            realOffset = optionalOffset.isPresent() ? optionalOffset.get() : -1L;
        }
        catch (Throwable t) {
            LOGGER.error("Failed to read offset, mq={}", (Object)mq, (Object)t);
        }
        return realOffset - (long)(consumer.getPullThresholdForQueue() * 2);
    }

    public static Set<MessageQueue> getMessageQueue(String consumerGroup, String topic) {
        HashSet<MessageQueue> mqAll = new HashSet<MessageQueue>();
        Set<DefaultMQPushConsumer> consumerSet = TransactionManager.getConsumer(consumerGroup);
        if (consumerSet == null || consumerSet.isEmpty()) {
            return mqAll;
        }
        for (DefaultMQPushConsumer consumer : consumerSet) {
            try {
                Set<MessageQueue> mqSet = consumer.getDefaultMQPushConsumerImpl().fetchSubscribeMessageQueues(topic);
                if (mqSet == null) continue;
                mqAll.addAll(mqSet);
            }
            catch (Exception e) {
                LogUtil.error(LOGGER, "fetchSubscribeMessageQueues fail, topic:{}, err:{}", (Object)topic, (Object)e.getMessage());
            }
        }
        return mqAll;
    }

    public static List<MessageQueue> getCurrentConsumeQueue(String consumerGroup) {
        Set<DefaultMQPushConsumer> consumerSet = TransactionManager.getConsumer(consumerGroup);
        if (consumerSet == null) {
            return null;
        }
        ArrayList<MessageQueue> mqAll = new ArrayList<MessageQueue>();
        for (DefaultMQPushConsumer consumer : consumerSet) {
            try {
                ConcurrentMap<MessageQueue, ProcessQueue> processTable = consumer.getDefaultMQPushConsumerImpl().getRebalanceImpl().getProcessQueueTable();
                if (processTable == null) continue;
                mqAll.addAll(processTable.keySet());
            }
            catch (Exception e) {
                LogUtil.error(LOGGER, "getProcessQueueTable fail, consumerGroup:{}, err:{}", (Object)consumer.getConsumerGroup(), (Object)e.getMessage());
            }
        }
        return mqAll;
    }
}

