/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.manager.util;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxRecord;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.DataSourceConfig;
import com.aliyun.openservices.ons.api.exactlyonce.manager.MetricService;
import com.aliyun.openservices.ons.api.exactlyonce.manager.datebase.AbstractDBAccessor;
import com.aliyun.openservices.ons.api.exactlyonce.manager.datebase.LoadRecordDo;
import com.aliyun.openservices.ons.api.exactlyonce.manager.datebase.MysqlAccessor;
import com.aliyun.openservices.ons.api.exactlyonce.manager.datebase.SqlServerAccessor;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.LogUtil;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;

public class DBAccessUtil {
    public static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private static final ConcurrentHashMap<String, DataSource> dataSourcePool = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, SQLExceptionTranslator> translatorMap = new ConcurrentHashMap();
    private static final int INNER_DATASOURCE_MAX_ACTIVE = 2;
    private static final int INNER_DATASOURCE_INIT_SIZE = 1;
    private static final int INNER_EVICT_CONNECTION_MILLIS = 30000;

    private static AbstractDBAccessor getDBAccessor(DataSourceConfig config) throws Exception {
        if (config == null || StringUtils.isEmpty(config.getDriver())) {
            throw new Exception("datasource driver invalid " + config);
        }
        switch (DBType.parseTypeFromDriver(config.getDriver())) {
            case MYSQL: {
                return MysqlAccessor.getInstance();
            }
            case SQLSERVER: {
                return SqlServerAccessor.getInstance();
            }
        }
        throw new Exception("unsupported db type" + config.getDriver());
    }

    private static Connection getInternalConnection(String url, String user, String passwd, String driver) {
        String uniqKey = new StringBuilder(256).append(url).append('\u0001').append(user).append('\u0001').append(passwd).append('\u0001').append(driver).toString();
        DataSource dataSource = dataSourcePool.get(uniqKey);
        try {
            if (dataSource == null) {
                HashMap<String, String> property = new HashMap<String, String>();
                property.put("driverClassName", driver);
                property.put("url", url);
                property.put("username", user);
                property.put("password", passwd);
                property.put("maxActive", String.valueOf(2));
                property.put("initialSize", String.valueOf(1));
                property.put("minEvictableIdleTimeMillis", String.valueOf(30000));
                dataSource = DruidDataSourceFactory.createDataSource(property);
                ((DruidDataSource)dataSource).setQueryTimeout(1);
                DataSource dataSourceOld = dataSourcePool.putIfAbsent(uniqKey, dataSource);
                if (dataSourceOld != null) {
                    ((DruidDataSource)dataSource).close();
                    dataSource = dataSourceOld;
                }
            }
            return dataSource.getConnection();
        }
        catch (Exception e) {
            LogUtil.error(LOGGER, "getInternalConnection fail, uniqKey:{}, err:{}", (Object)uniqKey, (Object)e.getMessage());
            return null;
        }
    }

    public static List<Long> queryAckedRecord(DataSourceConfig config, LoadRecordDo loadRecordDo) {
        List<Long> recordList = null;
        try {
            AbstractDBAccessor accessor = DBAccessUtil.getDBAccessor(config);
            Connection connection = DBAccessUtil.getInternalConnection(config.getUrl(), config.getUser(), config.getPasswd(), config.getDriver());
            if (accessor != null && connection != null) {
                long begin = System.currentTimeMillis();
                recordList = accessor.queryAckedRecord(connection, loadRecordDo);
                MetricService.getInstance().incQueryAcked(begin);
            }
        }
        catch (Exception e) {
            LogUtil.error(LOGGER, "query acked record fail, loadRecordDo:{}, err:{}", (Object)loadRecordDo, (Object)e.getMessage());
        }
        return recordList;
    }

    public static List<Long> queryExpiredRecord(DataSourceConfig config, Long timestamp, int count) {
        List<Long> recordList = null;
        try {
            AbstractDBAccessor accessor = DBAccessUtil.getDBAccessor(config);
            Connection connection = DBAccessUtil.getInternalConnection(config.getUrl(), config.getUser(), config.getPasswd(), config.getDriver());
            if (accessor != null & connection != null) {
                long begin = System.currentTimeMillis();
                recordList = accessor.queryExpiredRecord(connection, timestamp, count);
                MetricService.getInstance().incQueryExpired(begin);
            }
        }
        catch (Exception e) {
            LogUtil.error(LOGGER, "query acked record fail, timestamp:{}, count:{}, err:{}", timestamp, count, e.getMessage());
        }
        return recordList;
    }

    public static void insertTxRecord(Connection connection, DataSourceConfig config, MQTxRecord record) throws Exception {
        AbstractDBAccessor accessor = DBAccessUtil.getDBAccessor(config);
        if (accessor == null || connection == null) {
            throw new Exception("access db fail, config:" + config);
        }
        long begin = System.currentTimeMillis();
        accessor.insertRecord(connection, record, false);
        MetricService.getInstance().incInsertRecord(begin);
    }

    public static boolean isRecordExist(MQTxContext context) {
        DataSourceConfig config = context.getDataSourceConfig();
        String messageId = context.getMessageId();
        try {
            AbstractDBAccessor accessor = DBAccessUtil.getDBAccessor(config);
            Connection connection = DBAccessUtil.getInternalConnection(config.getUrl(), config.getUser(), config.getPasswd(), config.getDriver());
            if (accessor != null && connection != null) {
                long begin = System.currentTimeMillis();
                Long id = accessor.queryRecordCountByMsgId(connection, config, messageId);
                MetricService.getInstance().incQueryMsgIdCount(begin);
                if (id != null) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LogUtil.error(LOGGER, "query isRecordExist fail, msgId:{}, err:{}", (Object)context.getMessageId(), (Object)e.getMessage());
        }
        return false;
    }

    public static void deleteRecordById(DataSourceConfig config, List<Long> msgIds) throws Exception {
        AbstractDBAccessor accessor = DBAccessUtil.getDBAccessor(config);
        Connection connection = DBAccessUtil.getInternalConnection(config.getUrl(), config.getUser(), config.getPasswd(), config.getDriver());
        if (accessor == null || connection == null) {
            throw new Exception("access db fail, config:" + config);
        }
        long begin = System.currentTimeMillis();
        accessor.deleteRecordById(connection, msgIds);
        MetricService.getInstance().incDeleteRecord(begin);
    }

    public static boolean isRecordDupException(MQTxContext context, Exception e) {
        if (!(e instanceof SQLException)) {
            return false;
        }
        boolean isDup = DBAccessUtil.isDuplicateKeyException(context.getDataSourceConfig().getProductName(), (SQLException)e);
        if (isDup) {
            LogUtil.info(LOGGER, "exception is cased by record duped, context:{}, err:{}", (Object)context, (Object)e.getMessage());
        }
        return isDup;
    }

    private static boolean isDuplicateKeyException(String productName, SQLException e) {
        SQLExceptionTranslator oldTranslator;
        SQLExceptionTranslator sqlExceptionTranslator = translatorMap.get(productName);
        if (sqlExceptionTranslator == null && (oldTranslator = translatorMap.putIfAbsent(productName, sqlExceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(productName))) != null) {
            sqlExceptionTranslator = oldTranslator;
        }
        DataAccessException accessException = sqlExceptionTranslator.translate("", "", e);
        return accessException instanceof DuplicateKeyException;
    }

    public static enum DBType {
        MYSQL("mysql", "com.mysql.jdbc.Driver"),
        SQLSERVER("sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver"),
        ORACLE("oracle", "oracle.jdbc.driver.OracleDriver"),
        DB2("db2", "COM.ibm.db2.jdbc.app.DB2Driver");

        private String dbType;
        private String driver;

        private DBType(String dbType, String driver) {
            this.driver = driver;
        }

        public static DBType parseTypeFromDriver(String driver) {
            if (StringUtils.isEmpty(driver)) {
                return null;
            }
            for (DBType type : DBType.values()) {
                if (!type.driver.equals(driver)) continue;
                return type;
            }
            return null;
        }
    }
}

