/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.manager.impl;

import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.LogUtil;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.MetricsUtil;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.TxContextUtil;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.utils.ThreadUtils;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MetricServiceImpl {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private volatile int commitQps;
    private volatile int rollbackQps;
    private volatile long averageProcessTime;
    private volatile long averagePersistenceTime;
    private volatile long averageConsumeTime;
    private volatile AtomicInteger commitTotal = new AtomicInteger(0);
    private volatile AtomicInteger rollbackTotal = new AtomicInteger(0);
    private volatile AtomicLong processTimeTotal = new AtomicLong(0L);
    private volatile AtomicLong persistenceTimeTotal = new AtomicLong(0L);
    private volatile AtomicLong consumeTimeTotal = new AtomicLong(0L);
    private volatile AtomicLong forbidDupTimes = new AtomicLong(0L);
    private volatile int queryAckedPre;
    private volatile int queryExpiredPre;
    private volatile int queryMsgIdCountPre;
    private volatile int insertRecordPre;
    private volatile int deleteRecordPre;
    private volatile int dbReadPre;
    private volatile int dbWritePre;
    private volatile long queryAckedRt;
    private volatile long queryExpiredRt;
    private volatile long queryMsgIdCountRt;
    private volatile long insertRecordRt;
    private volatile long deleteRecordRt;
    private volatile AtomicLong queryAckedTimeUsed = new AtomicLong(0L);
    private volatile AtomicLong queryExpiredTimeUsed = new AtomicLong(0L);
    private volatile AtomicLong queryMsgIdCountTimeUsed = new AtomicLong(0L);
    private volatile AtomicLong insertRecordTimeUsed = new AtomicLong(0L);
    private volatile AtomicLong deleteRecordTimeUsed = new AtomicLong(0L);
    private volatile AtomicInteger queryAckedTimes = new AtomicInteger(0);
    private volatile AtomicInteger queryExpiredTimes = new AtomicInteger(0);
    private volatile AtomicInteger queryMsgIdCountTimes = new AtomicInteger(0);
    private volatile AtomicInteger insertRecordTimes = new AtomicInteger(0);
    private volatile AtomicInteger deleteRecordTimes = new AtomicInteger(0);
    private volatile AtomicInteger dbRead = new AtomicInteger(0);
    private volatile AtomicInteger dbWrite = new AtomicInteger(0);
    private ScheduledThreadPoolExecutor refreshExecuter = new ScheduledThreadPoolExecutor(1, ThreadUtils.newThreadFactory("ExactlyOnceConsumer", false));

    public void record(MQTxContext context) {
        if (context == null) {
            return;
        }
        this.record(context.getMessageId(), MetricsUtil.getProcessTime(context), MetricsUtil.getPersistenceTime(context), MetricsUtil.getConsumeTime(context), System.currentTimeMillis(), TxContextUtil.isTxContextCommitted(context), context.isDup());
    }

    public void record(String messageId, long processTime, long persistenceTime, long consumeTime, long timestamp, boolean isCommit, boolean isDup) {
        this.processTimeTotal.addAndGet(processTime);
        this.persistenceTimeTotal.addAndGet(persistenceTime);
        this.consumeTimeTotal.addAndGet(consumeTime);
        if (isDup) {
            this.forbidDupTimes.incrementAndGet();
        }
        if (isCommit) {
            this.commitTotal.incrementAndGet();
        } else {
            this.rollbackTotal.incrementAndGet();
        }
        LogUtil.debug(LOGGER, "record consume status, msgId:{}, processTime:{}, persistenceTime:{}, consumeTime:{} recordTimestamp:{}, commit:{}, dup:{}", messageId, processTime, persistenceTime, consumeTime, timestamp, isCommit, isDup);
    }

    public void computeTxStatsData() {
        try {
            int consumeCount = this.commitTotal.get() + this.rollbackTotal.get();
            this.commitQps = this.commitTotal.getAndSet(0) / 60;
            this.rollbackQps = this.rollbackTotal.getAndSet(0) / 60;
            this.averageProcessTime = consumeCount == 0 ? 0L : this.processTimeTotal.getAndSet(0L) / (long)consumeCount;
            this.averagePersistenceTime = consumeCount == 0 ? 0L : this.persistenceTimeTotal.getAndSet(0L) / (long)consumeCount;
            this.averageConsumeTime = consumeCount == 0 ? 0L : this.consumeTimeTotal.getAndSet(0L) / (long)consumeCount;
            this.queryAckedPre = this.queryAckedTimes.getAndSet(0);
            this.queryExpiredPre = this.queryExpiredTimes.getAndSet(0);
            this.queryMsgIdCountPre = this.queryMsgIdCountTimes.getAndSet(0);
            this.insertRecordPre = this.insertRecordTimes.getAndSet(0);
            this.deleteRecordPre = this.deleteRecordTimes.getAndSet(0);
            this.dbReadPre = this.dbRead.getAndSet(0);
            this.dbWritePre = this.dbWrite.getAndSet(0);
            this.queryAckedRt = this.queryAckedPre == 0 ? 0L : this.queryAckedTimeUsed.getAndSet(0L) / (long)this.queryAckedPre;
            this.queryExpiredRt = this.queryExpiredPre == 0 ? 0L : this.queryExpiredTimeUsed.getAndSet(0L) / (long)this.queryExpiredPre;
            this.queryMsgIdCountRt = this.queryMsgIdCountPre == 0 ? 0L : this.queryMsgIdCountTimeUsed.getAndSet(0L) / (long)this.queryMsgIdCountPre;
            this.insertRecordRt = this.insertRecordPre == 0 ? 0L : this.insertRecordTimeUsed.getAndSet(0L) / (long)this.insertRecordPre;
            this.deleteRecordRt = this.deleteRecordPre == 0 ? 0L : this.deleteRecordTimeUsed.getAndSet(0L) / (long)this.deleteRecordPre;
            LogUtil.info(LOGGER, "Metrics forbidDupCount:{}, commitQps:{}, rollbackQps:{}, averageProcessTime:{}ms, averagePersistenceTime:{}ms, averageConsumeTime:{}ms queryAcked:{}/min, queryExpired:{}/min, queryMsgCount:{}/min, insertRecord:{}/min, deleteRecord:{}/min, dbRead:{}/min, dbWrite:{}/min queryAckedRt:{}ms, queryExpiredRt:{}ms, queryMsgCountRt:{}ms, insertRecordRt:{}ms, deleteRecordRt:{}ms", this.forbidDupTimes, this.commitQps, this.rollbackQps, this.averageProcessTime, this.averagePersistenceTime, this.averageConsumeTime, this.queryAckedPre, this.queryExpiredPre, this.queryMsgIdCountPre, this.insertRecordPre, this.deleteRecordPre, this.dbReadPre, this.dbWritePre, this.queryAckedRt, this.queryExpiredRt, this.queryMsgIdCountRt, this.insertRecordRt, this.deleteRecordRt);
        }
        catch (Throwable e) {
            LogUtil.error(LOGGER, "computeTxStats fail:{}", (Object)e.getMessage());
        }
    }

    public Map<String, String> getCurrentConsumeStatus() {
        HashMap<String, String> statusMap = new HashMap<String, String>(13);
        statusMap.put("commitQps", String.valueOf(this.commitQps));
        statusMap.put("rollbackQps", String.valueOf(this.rollbackQps));
        statusMap.put("averageConsumeTime", String.valueOf(this.averageConsumeTime));
        statusMap.put("averageProcessTime", String.valueOf(this.averageProcessTime));
        statusMap.put("averagePersistenceTime", String.valueOf(this.averagePersistenceTime));
        statusMap.put("totalForbidDuplication", String.valueOf(this.forbidDupTimes.get()));
        statusMap.put("dbQueryAcked", String.valueOf(this.queryAckedPre));
        statusMap.put("dbQueryExpired", String.valueOf(this.queryExpiredPre));
        statusMap.put("dbQueryMsgIdCount", String.valueOf(this.queryMsgIdCountPre));
        statusMap.put("dbInsertRecord", String.valueOf(this.insertRecordPre));
        statusMap.put("dbDeleteRecord", String.valueOf(this.deleteRecordPre));
        statusMap.put("dbRead", String.valueOf(this.dbReadPre));
        statusMap.put("dbWrite", String.valueOf(this.dbWrite));
        statusMap.put("dbQueryAckedRt", String.valueOf(this.queryAckedRt));
        statusMap.put("dbQueryExpiredRt", String.valueOf(this.queryExpiredRt));
        statusMap.put("dbQueryMsgIdCountRt", String.valueOf(this.queryMsgIdCountRt));
        statusMap.put("dbInsertRecordRt", String.valueOf(this.insertRecordRt));
        statusMap.put("dbDeleteRecordRt", String.valueOf(this.deleteRecordRt));
        return statusMap;
    }

    public void incQueryExpired(long begin) {
        this.queryExpiredTimes.incrementAndGet();
        this.dbRead.incrementAndGet();
        this.queryExpiredTimeUsed.addAndGet(System.currentTimeMillis() - begin);
    }

    public void incQueryAcked(long begin) {
        this.queryAckedTimes.incrementAndGet();
        this.dbRead.incrementAndGet();
        this.queryAckedTimeUsed.addAndGet(System.currentTimeMillis() - begin);
    }

    public void incQueryMsgIdCount(long begin) {
        this.queryMsgIdCountTimes.incrementAndGet();
        this.dbRead.incrementAndGet();
        this.queryMsgIdCountTimeUsed.addAndGet(System.currentTimeMillis() - begin);
    }

    public void incInsertRecord(long begin) {
        this.insertRecordTimes.incrementAndGet();
        this.dbWrite.incrementAndGet();
        this.insertRecordTimeUsed.addAndGet(System.currentTimeMillis() - begin);
    }

    public void incDeleteRecord(long begin) {
        this.deleteRecordTimes.incrementAndGet();
        this.dbWrite.incrementAndGet();
        this.deleteRecordTimeUsed.addAndGet(System.currentTimeMillis() - begin);
    }

    public void incRead() {
        this.dbRead.incrementAndGet();
    }

    public void incWrite() {
        this.dbWrite.incrementAndGet();
    }

    public void start() {
        this.refreshExecuter.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MetricServiceImpl.this.computeTxStatsData();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public void stop() {
        ThreadUtils.shutdownGracefully(this.refreshExecuter, 10000L, TimeUnit.MILLISECONDS);
    }
}

