/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.manager.datebase;

import com.aliyun.openservices.ons.api.exactlyonce.manager.datebase.AbstractDBAccessor;
import com.aliyun.openservices.ons.api.exactlyonce.manager.datebase.LoadRecordDo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import java.sql.Connection;
import java.sql.PreparedStatement;

public class SqlServerAccessor
extends AbstractDBAccessor {
    private SqlServerAccessor() {
    }

    @Override
    protected PreparedStatement queryAckedRecordStatement(Connection connection, LoadRecordDo loadRecordDo) throws Exception {
        MessageQueue mq = loadRecordDo.getMessageQueue();
        PreparedStatement statement = connection.prepareStatement(this.queryAckedRecordWithoutCheckIdSql());
        statement.setInt(1, loadRecordDo.getCount());
        statement.setString(2, loadRecordDo.getConsumerGroup());
        statement.setString(3, mq.getTopic());
        statement.setString(4, mq.getBrokerName());
        statement.setInt(5, mq.getQueueId());
        statement.setLong(6, loadRecordDo.getOffset());
        statement.setLong(7, loadRecordDo.getTimestamp());
        return statement;
    }

    @Override
    protected PreparedStatement queryExpiredRecordStatement(Connection connection, Long timestamp, int count) throws Exception {
        PreparedStatement statement = connection.prepareStatement(this.queryExpirededRecordSql());
        statement.setLong(1, timestamp);
        statement.setInt(2, count);
        return statement;
    }

    @Override
    protected String queryExpirededRecordSql() {
        return "SELECT top (?) id FROM transaction_record WHERE ctime<? ORDER BY ctime ASC";
    }

    @Override
    protected String queryAckedRecordSql() {
        return "SELECT top (?) id FROM transaction_record WHERE consumer_group=? AND topic_name=? AND broker_name=? AND queue_id=? AND offset<? AND ctime<? AND id>=? ORDER BY id ASC";
    }

    @Override
    protected String queryAckedRecordWithoutCheckIdSql() {
        return "SELECT top (?) id FROM transaction_record WHERE consumer_group=? AND topic_name=? AND broker_name=? AND queue_id=? AND offset<? AND ctime<?";
    }

    @Override
    protected String queryRecordCountByMsgIdSql() {
        return "SELECT id FROM transaction_record WHERE message_id=?";
    }

    @Override
    protected String insertRecordSql() {
        return "INSERT INTO transaction_record (topic_name, consumer_group, broker_name, queue_id, offset, message_id, ctime) VALUES(?,?,?,?,?,?,?)";
    }

    @Override
    protected String deleteRecordByMsgIdSql() {
        return "DELETE FROM transaction_record WHERE id in (%s)";
    }

    public static AbstractDBAccessor getInstance() {
        return SqlServerAccessorHolder.INSTANCE;
    }

    private static class SqlServerAccessorHolder {
        private static final AbstractDBAccessor INSTANCE = new SqlServerAccessor();

        private SqlServerAccessorHolder() {
        }
    }
}

