/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.manager.datebase;

import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxRecord;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.DataSourceConfig;
import com.aliyun.openservices.ons.api.exactlyonce.manager.datebase.LoadRecordDo;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDBAccessor {
    protected abstract PreparedStatement queryAckedRecordStatement(Connection var1, LoadRecordDo var2) throws Exception;

    protected abstract PreparedStatement queryExpiredRecordStatement(Connection var1, Long var2, int var3) throws Exception;

    protected abstract String queryExpirededRecordSql();

    protected abstract String queryAckedRecordSql();

    protected abstract String queryAckedRecordWithoutCheckIdSql();

    protected abstract String queryRecordCountByMsgIdSql();

    protected abstract String insertRecordSql();

    protected abstract String deleteRecordByMsgIdSql();

    public List<Long> queryAckedRecord(Connection connection, LoadRecordDo loadRecordDo) throws Exception {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.queryAckedRecordStatement(connection, loadRecordDo);
            resultSet = statement.executeQuery();
            ArrayList<Long> recordList = new ArrayList<Long>();
            while (resultSet.next()) {
                recordList.add(resultSet.getLong("id"));
            }
            ArrayList<Long> arrayList = recordList;
            this.closeResource(resultSet, statement, connection);
            return arrayList;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResource(resultSet, statement, connection);
                throw throwable;
            }
        }
    }

    public List<Long> queryExpiredRecord(Connection connection, Long timestamp, int count) throws Exception {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.queryExpiredRecordStatement(connection, timestamp, count);
            resultSet = statement.executeQuery();
            ArrayList<Long> recordList = new ArrayList<Long>();
            while (resultSet.next()) {
                recordList.add(resultSet.getLong("id"));
            }
            ArrayList<Long> arrayList = recordList;
            this.closeResource(resultSet, statement, connection);
            return arrayList;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResource(resultSet, statement, connection);
                throw throwable;
            }
        }
    }

    public Long queryRecordCountByMsgId(Connection connection, DataSourceConfig config, String messageId) throws Exception {
        ResultSet resultSet;
        PreparedStatement statement;
        block5: {
            statement = null;
            resultSet = null;
            statement = connection.prepareStatement(this.queryRecordCountByMsgIdSql());
            statement.setString(1, messageId);
            resultSet = statement.executeQuery();
            if (!resultSet.next()) break block5;
            Long l = resultSet.getLong(1);
            this.closeResource(resultSet, statement, connection);
            return l;
        }
        try {
            Long l = null;
            this.closeResource(resultSet, statement, connection);
            return l;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResource(resultSet, statement, connection);
                throw throwable;
            }
        }
    }

    public void insertRecord(Connection connection, MQTxRecord record, boolean needCloseConn) throws Exception {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(this.insertRecordSql());
            statement.setString(1, record.getTopicName());
            statement.setString(2, record.getConsumerGroup());
            statement.setString(3, record.getBrokerName());
            statement.setInt(4, record.getQid());
            statement.setLong(5, record.getOffset());
            statement.setString(6, record.getMessageId());
            statement.setLong(7, record.getCreateTime());
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.closeResource(null, statement, connection, needCloseConn);
        }
    }

    public void deleteRecordById(Connection connection, List<Long> ids) throws Exception {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            if (statement == null) {
                throw new Exception("create deleteRecordById statement fail");
            }
            String delSet = StringUtils.join(ids, ",");
            statement.execute(String.format(this.deleteRecordByMsgIdSql(), delSet));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.closeResource(null, statement, connection);
        }
    }

    private void closeResource(ResultSet resultSet, Statement statement, Connection connection) {
        this.closeResource(resultSet, statement, connection, true);
    }

    private void closeResource(ResultSet resultSet, Statement statement, Connection connection, boolean needCloseConn) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (needCloseConn && connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

