/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.manager;

import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.DataSourceConfig;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.MQTxConnection;
import com.aliyun.openservices.ons.api.exactlyonce.manager.MetricService;
import com.aliyun.openservices.ons.api.exactlyonce.manager.TxRecordManager;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.LogUtil;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.ConcurrentSet;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TransactionManager {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private static ConcurrentMap<String, ConcurrentSet<DefaultMQPushConsumer>> consumerMap = new ConcurrentHashMap<String, ConcurrentSet<DefaultMQPushConsumer>>();
    private static ConcurrentMap<DataSourceConfig, ConcurrentSet<String>> consumerSessionMap = new ConcurrentHashMap<DataSourceConfig, ConcurrentSet<String>>();
    private static volatile AtomicBoolean started = new AtomicBoolean(false);
    private static TxRecordManager txRecordManager;

    public static void start(Properties properties) {
        if (!started.compareAndSet(false, true)) {
            return;
        }
        LogUtil.info(LOGGER, "start TransactionManager...");
        txRecordManager = new TxRecordManager(properties);
        txRecordManager.start();
        MetricService.getInstance().start();
    }

    public static void stop() {
        if (!started.compareAndSet(true, false)) {
            return;
        }
        txRecordManager.stop();
        MetricService.getInstance().stop();
    }

    public static void addConsumer(String consumerGroup, DefaultMQPushConsumer defaultMQPushConsumer) {
        ConcurrentSet consumerSet = (ConcurrentSet)consumerMap.get(consumerGroup);
        if (consumerSet == null) {
            ConcurrentSet<DefaultMQPushConsumer> newConsumerSet = new ConcurrentSet<DefaultMQPushConsumer>();
            newConsumerSet.add(defaultMQPushConsumer);
            ConcurrentSet<DefaultMQPushConsumer> old = consumerMap.putIfAbsent(consumerGroup, newConsumerSet);
            if (old != null) {
                old.add(defaultMQPushConsumer);
            }
        } else {
            consumerSet.add(defaultMQPushConsumer);
        }
    }

    public static Set<DefaultMQPushConsumer> getConsumer(String consumerGroup) {
        return (Set)consumerMap.get(consumerGroup);
    }

    public static void flushTxRecord(MQTxConnection connection, MQTxContext context) throws Exception {
        txRecordManager.flushTxRecord(connection, context);
    }

    public static void updateConsumeSessionMap(DataSourceConfig config, String consumerGroup) {
        if (config == null || StringUtils.isEmpty(consumerGroup)) {
            return;
        }
        ConcurrentSet cidSet = (ConcurrentSet)consumerSessionMap.get(config);
        if (cidSet == null) {
            ConcurrentSet<String> newCidSet = new ConcurrentSet<String>();
            newCidSet.add(consumerGroup);
            ConcurrentSet<String> old = consumerSessionMap.putIfAbsent(config, newCidSet);
            if (old != null) {
                old.add(consumerGroup);
            }
        } else {
            cidSet.add(consumerGroup);
        }
    }

    public static ConcurrentMap<DataSourceConfig, ConcurrentSet<String>> getConsumerSessionMap() {
        return consumerSessionMap;
    }
}

