/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.datasource.core;

import com.aliyun.openservices.ons.api.exactlyonce.aop.model.LocalTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.DataSourceConfig;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.AbstractMQTxStatement;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.ExecResult;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.MQTxConnection;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.SQLExecuteType;
import com.aliyun.openservices.ons.api.exactlyonce.manager.TransactionManager;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.LogUtil;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.MetricsUtil;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ExecuterFactory {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();

    public static <T> ExecResult<T> execute(AbstractMQTxStatement statement, String sql, SQLExecuteType type, Object args) throws SQLException {
        MQTxContext context = LocalTxContext.get();
        DataSourceConfig dsConfig = statement.getTxDataSource().getDataSourceConfig();
        context.setDataSourceConfig(dsConfig);
        TransactionManager.updateConsumeSessionMap(dsConfig, context.getConsumerGroup());
        boolean isAutoCommit = context.isAutoCommit() && statement.getConnection().getAutoCommit();
        MetricsUtil.recordPersistenceTimestamp(context);
        ExecResult<T> result = isAutoCommit ? ExecuterFactory.executeWithAutoCommit(context, statement, sql, type, args) : ExecuterFactory.executeWithoutAutoCommit(context, statement, sql, type, args);
        MetricsUtil.recordAfterPersistenceTimestamp(context);
        return result;
    }

    private static <T> ExecResult<T> executeWithAutoCommit(MQTxContext context, AbstractMQTxStatement statement, String sql, SQLExecuteType type, Object args) throws SQLException {
        ExecResult result;
        MQTxConnection txConn = null;
        try {
            txConn = statement.getTxConnection();
            txConn.setAutoCommit(false);
            result = ExecuterFactory.executeSql(statement, sql, type, args);
            txConn.commit();
        }
        catch (SQLException e1) {
            LogUtil.error(LOGGER, "executeWithAutoCommit fail, context:{}, SQLException:{}", (Object)context, (Object)e1.getMessage());
            txConn.rollback();
            throw e1;
        }
        catch (Throwable e2) {
            LogUtil.error(LOGGER, "executeWithAutoCommit fail, context:{}, Exception:{}", (Object)context, (Object)e2.getMessage());
            txConn.rollback();
            throw new SQLException(e2);
        }
        finally {
            context.setInTxEnv(false);
            txConn.setAutoCommit(true);
        }
        return result;
    }

    private static <T> ExecResult<T> executeWithoutAutoCommit(MQTxContext context, AbstractMQTxStatement statement, String sql, SQLExecuteType type, Object args) throws SQLException {
        ExecResult result;
        try {
            Connection connection = statement.getConnection();
            connection.setAutoCommit(false);
            result = ExecuterFactory.executeSql(statement, sql, type, args);
        }
        catch (SQLException e1) {
            LogUtil.error(LOGGER, "executeWithoutAutoCommit fail, context:{}, SQLException:{}", (Object)context, (Object)e1.getMessage());
            throw e1;
        }
        catch (Throwable e2) {
            LogUtil.error(LOGGER, "executeWithoutAutoCommit fail, context:{}, Exception:{}", (Object)context, (Object)e2.getMessage());
            throw new SQLException(e2);
        }
        return result;
    }

    public static ExecResult executeSql(AbstractMQTxStatement statement, String sql, SQLExecuteType type, Object args) throws SQLException {
        try {
            switch (type) {
                case EXECUTE_STRING: {
                    boolean ret = statement.getTargetStatement().execute(sql);
                    return new ExecResult<Boolean>(ret);
                }
                case EXECUTE_STRING_INT: {
                    int autoGeneratedKeys = (Integer)args;
                    boolean ret = statement.getTargetStatement().execute(sql, autoGeneratedKeys);
                    return new ExecResult<Boolean>(ret);
                }
                case EXECUTE_STRING_INTARRAY: {
                    int[] columnIndexes = (int[])args;
                    boolean ret = statement.getTargetStatement().execute(sql, columnIndexes);
                    return new ExecResult<Boolean>(ret);
                }
                case EXECUTE_STRING_STRINGARRAY: {
                    String[] columnNames = (String[])args;
                    boolean ret = statement.getTargetStatement().execute(sql, columnNames);
                    return new ExecResult<Boolean>(ret);
                }
                case EXECUTEUPDATE_STRING: {
                    int ret = statement.getTargetStatement().executeUpdate(sql);
                    return new ExecResult<Integer>(ret);
                }
                case EXECUTEUPDATE_STRING_INT: {
                    int autoGeneratedKeys = (Integer)args;
                    int ret = statement.getTargetStatement().executeUpdate(sql, autoGeneratedKeys);
                    return new ExecResult<Integer>(ret);
                }
                case EXECUTEUPDATE_STRING_INTARRAY: {
                    int[] columnIndexes = (int[])args;
                    int ret = statement.getTargetStatement().executeUpdate(sql, columnIndexes);
                    return new ExecResult<Integer>(ret);
                }
                case EXECUTEUPDATE_STRING_STRINGARRAY: {
                    String[] columnNames = (String[])args;
                    int ret = statement.getTargetStatement().executeUpdate(sql, columnNames);
                    return new ExecResult<Integer>(ret);
                }
                case EXECUTEBATCH_VOID: {
                    int[] ret = statement.getTargetStatement().executeBatch();
                    return new ExecResult<int[]>(ret);
                }
                case PREPARED_EXECUTE_VOID: {
                    boolean ret = ((PreparedStatement)statement.getTargetStatement()).execute();
                    return new ExecResult<Boolean>(ret);
                }
                case PREPARED_EXECUTEUPDATE_VOID: {
                    int ret = ((PreparedStatement)statement.getTargetStatement()).executeUpdate();
                    return new ExecResult<Integer>(ret);
                }
                case PREPARED_EXECUTEBATCH_VOID: {
                    int[] ret = ((PreparedStatement)statement.getTargetStatement()).executeBatch();
                    return new ExecResult<int[]>(ret);
                }
            }
            LogUtil.error(LOGGER, "Invalid SQL type:{}", (Object)type.getFullName());
            return null;
        }
        catch (SQLException e1) {
            LogUtil.error(LOGGER, "Execute SQL fail, type:{}, sql:{}, err:{}", type.getFullName(), sql, e1.getMessage());
            throw e1;
        }
    }
}

