/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.datasource.core;

import com.aliyun.openservices.ons.api.exactlyonce.MQUnsupportException;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.LocalTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.SQLUtil;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.AbstractMQTxDataSource;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.ExecResult;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.ExecuterFactory;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.MQTxConnection;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.SQLExecuteType;
import com.aliyun.openservices.ons.api.exactlyonce.manager.MetricService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public abstract class AbstractMQTxStatement
implements Statement {
    protected AbstractMQTxDataSource dataSource;
    protected MQTxConnection conn;
    protected Statement targetStatement;
    protected String targetSql;

    public AbstractMQTxStatement(AbstractMQTxDataSource dataSource, MQTxConnection connection, Statement statement) {
        this.dataSource = dataSource;
        this.conn = connection;
        this.targetStatement = statement;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.targetSql = sql;
        return this.targetStatement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.targetSql = sql;
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv() && SQLUtil.isWriteSql(sql)) {
            MetricService.getInstance().incWrite();
            ExecResult result = ExecuterFactory.execute(this, sql, SQLExecuteType.EXECUTEUPDATE_STRING, null);
            return (Integer)result.getResult();
        }
        return this.targetStatement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.targetStatement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.targetStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.targetStatement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.targetStatement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.targetStatement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.targetStatement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.targetStatement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.targetStatement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.targetStatement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.targetStatement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.targetStatement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.targetStatement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.targetSql = sql;
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv()) {
            if (SQLUtil.isReadSql(sql)) {
                this.executeQuery(sql);
                return true;
            }
            if (SQLUtil.isWriteSql(sql)) {
                MetricService.getInstance().incWrite();
                ExecuterFactory.execute(this, sql, SQLExecuteType.EXECUTE_STRING, null);
                return false;
            }
        }
        return this.targetStatement.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.targetStatement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.targetStatement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.targetStatement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.targetStatement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.targetStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.targetStatement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.targetStatement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.targetStatement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.targetStatement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.targetStatement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.targetStatement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv()) {
            MetricService.getInstance().incWrite();
            ExecResult result = ExecuterFactory.execute(this, null, SQLExecuteType.EXECUTEBATCH_VOID, null);
            return (int[])result.getResult();
        }
        return this.targetStatement.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.targetStatement.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.targetStatement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.targetStatement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.targetSql = sql;
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv() && SQLUtil.isWriteSql(sql)) {
            MetricService.getInstance().incWrite();
            ExecResult result = ExecuterFactory.execute(this, sql, SQLExecuteType.EXECUTEUPDATE_STRING_INT, autoGeneratedKeys);
            return (Integer)result.getResult();
        }
        return this.targetStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.targetSql = sql;
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv() && SQLUtil.isWriteSql(sql)) {
            MetricService.getInstance().incWrite();
            ExecResult result = ExecuterFactory.execute(this, sql, SQLExecuteType.EXECUTEUPDATE_STRING_INTARRAY, columnIndexes);
            return (Integer)result.getResult();
        }
        return this.targetStatement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.targetSql = sql;
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv() && SQLUtil.isWriteSql(sql)) {
            MetricService.getInstance().incWrite();
            ExecResult result = ExecuterFactory.execute(this, sql, SQLExecuteType.EXECUTEUPDATE_STRING_STRINGARRAY, columnNames);
            return (Integer)result.getResult();
        }
        return this.targetStatement.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.targetSql = sql;
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv()) {
            if (SQLUtil.isReadSql(sql)) {
                this.executeQuery(sql);
                return true;
            }
            if (SQLUtil.isWriteSql(sql)) {
                MetricService.getInstance().incWrite();
                ExecuterFactory.execute(this, sql, SQLExecuteType.EXECUTE_STRING_INT, autoGeneratedKeys);
                return false;
            }
        }
        return this.targetStatement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.targetSql = sql;
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv()) {
            if (SQLUtil.isReadSql(sql)) {
                this.executeQuery(sql);
                return true;
            }
            if (SQLUtil.isWriteSql(sql)) {
                MetricService.getInstance().incWrite();
                ExecuterFactory.execute(this, sql, SQLExecuteType.EXECUTE_STRING_INTARRAY, columnIndexes);
                return false;
            }
        }
        return this.targetStatement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.targetSql = sql;
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv()) {
            if (SQLUtil.isReadSql(sql)) {
                this.executeQuery(sql);
                return true;
            }
            if (SQLUtil.isWriteSql(sql)) {
                MetricService.getInstance().incWrite();
                ExecuterFactory.execute(this, sql, SQLExecuteType.EXECUTE_STRING_STRINGARRAY, columnNames);
                return false;
            }
        }
        return this.targetStatement.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.targetStatement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.targetStatement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.targetStatement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.targetStatement.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new MQUnsupportException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new MQUnsupportException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.targetStatement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.targetStatement.isWrapperFor(iface);
    }

    public Statement getTargetStatement() {
        return this.targetStatement;
    }

    public AbstractMQTxDataSource getTxDataSource() {
        return this.dataSource;
    }

    public MQTxConnection getTxConnection() {
        return this.conn;
    }
}

