/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.datasource.core;

import com.aliyun.openservices.ons.api.exactlyonce.aop.model.LocalTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.SQLUtil;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.AbstractMQTxDataSource;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.AbstractMQTxStatement;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.ExecResult;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.ExecuterFactory;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.MQTxConnection;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.core.SQLExecuteType;
import com.aliyun.openservices.ons.api.exactlyonce.manager.MetricService;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class AbstractMQTxPreparedStatement
extends AbstractMQTxStatement
implements PreparedStatement {
    public AbstractMQTxPreparedStatement(AbstractMQTxDataSource dataSource, MQTxConnection connection, PreparedStatement preparedStatement, String sql) {
        super(dataSource, connection, preparedStatement);
        this.targetSql = sql;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return ((PreparedStatement)this.targetStatement).executeQuery();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        ((PreparedStatement)this.targetStatement).setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.targetStatement).clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        ((PreparedStatement)this.targetStatement).setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv()) {
            if (SQLUtil.isReadSql(this.targetSql)) {
                this.executeQuery();
                return true;
            }
            if (SQLUtil.isWriteSql(this.targetSql)) {
                MetricService.getInstance().incWrite();
                ExecuterFactory.execute(this, null, SQLExecuteType.PREPARED_EXECUTE_VOID, null);
                return false;
            }
        }
        return ((PreparedStatement)this.targetStatement).execute();
    }

    @Override
    public int executeUpdate() throws SQLException {
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv() && SQLUtil.isWriteSql(this.targetSql)) {
            MetricService.getInstance().incWrite();
            ExecResult result = ExecuterFactory.execute(this, null, SQLExecuteType.PREPARED_EXECUTE_VOID, null);
            return (Integer)result.getResult();
        }
        return ((PreparedStatement)this.targetStatement).executeUpdate();
    }

    @Override
    public void addBatch() throws SQLException {
        ((PreparedStatement)this.targetStatement).addBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        MQTxContext context = LocalTxContext.get();
        if (context != null && context.isInTxEnv()) {
            MetricService.getInstance().incWrite();
            ExecResult result = ExecuterFactory.execute(this, null, SQLExecuteType.PREPARED_EXECUTEBATCH_VOID, null);
            return (int[])result.getResult();
        }
        return ((PreparedStatement)this.targetStatement).executeBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setClob(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.targetStatement).getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.targetStatement).setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.targetStatement).setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.targetStatement).setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        ((PreparedStatement)this.targetStatement).setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.targetStatement).getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        ((PreparedStatement)this.targetStatement).setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        ((PreparedStatement)this.targetStatement).setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        ((PreparedStatement)this.targetStatement).setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        ((PreparedStatement)this.targetStatement).setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        ((PreparedStatement)this.targetStatement).setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        ((PreparedStatement)this.targetStatement).setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        ((PreparedStatement)this.targetStatement).setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        ((PreparedStatement)this.targetStatement).setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        ((PreparedStatement)this.targetStatement).setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        ((PreparedStatement)this.targetStatement).setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        ((PreparedStatement)this.targetStatement).setNClob(parameterIndex, reader);
    }
}

