/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.aop.proxy.impl;

import com.aliyun.openservices.ons.api.exactlyonce.aop.annotation.MQTransaction;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.LocalTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.aop.proxy.InternalCallback;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.MetricsUtil;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.TxContextUtil;
import com.aliyun.openservices.ons.api.exception.ONSClientException;

public class ProxyTxExecuterImpl {
    public Object excute(InternalCallback callback) {
        return this.excute(callback, null);
    }

    public Object excute(InternalCallback callback, Object object) {
        if (callback == null) {
            throw new ONSClientException("consume method not found");
        }
        if (object != null) {
            MQTransaction transaction = (MQTransaction)object;
            this.begin(transaction.timeout());
        } else {
            this.begin();
        }
        Object result = callback.run();
        MetricsUtil.recordFinishConsumeTimestamp(LocalTxContext.get());
        return result;
    }

    public void begin() {
        this.begin(-1);
    }

    public void begin(int timeout) {
        MQTxContext txContext = LocalTxContext.get();
        if (txContext == null) {
            txContext = TxContextUtil.buildTxContext();
        } else {
            TxContextUtil.updateTxContext(txContext);
        }
        if (0 < timeout && 600000 >= timeout) {
            txContext.setTimeoutMs(timeout);
        }
        txContext.setInTxEnv(true);
        MetricsUtil.recordProcessTimeStamp(txContext);
        LocalTxContext.set(txContext);
    }

    public void commit() {
        MQTxContext context = LocalTxContext.get();
        if (!TxContextUtil.isTxContextFinished(context)) {
            context.setStage(MQTxContext.TxStage.COMMIT);
            context.setStatus(MQTxContext.TxStatus.PROCESS_OK);
        }
    }

    public void rollback() {
        MQTxContext context = LocalTxContext.get();
        if (!TxContextUtil.isTxContextFinished(context)) {
            context.setStage(MQTxContext.TxStage.ROLLBACK);
            context.setStatus(MQTxContext.TxStatus.USER_PROCESS_FAIL);
        }
    }
}

