/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce.aop.proxy;

import com.aliyun.openservices.ons.api.exactlyonce.aop.annotation.MQTransaction;
import com.aliyun.openservices.ons.api.exactlyonce.aop.proxy.AbstractMQTransactionScanner;
import com.aliyun.openservices.ons.api.exactlyonce.aop.proxy.MQTransactionInterceptor;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.AopUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class MQTransactionScaner
extends AbstractMQTransactionScanner {
    private boolean enableTransaction = true;
    private MQTransactionInterceptor interceptor;
    private HashSet<String> proxyMethodSet = new HashSet();
    private boolean isEnableTransaction = true;

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        HashSet<String> hashSet = this.proxyMethodSet;
        synchronized (hashSet) {
            if (this.proxyMethodSet.contains(beanName)) {
                return bean;
            }
            this.proxyMethodSet.add(beanName);
        }
        try {
            Class<?> targetInterface = AopUtil.findTargetClass(bean);
            Method[] methods = targetInterface.getMethods();
            HashMap<Object, MQTransaction> methodMap = new HashMap<Object, MQTransaction>();
            for (Method method : methods) {
                MQTransaction mqTransaction = method.getAnnotation(MQTransaction.class);
                if (mqTransaction == null || !this.isEnableTransaction) continue;
                methodMap.put(AopUtil.formatMethod(method), mqTransaction);
            }
            if (methodMap.isEmpty()) {
                return bean;
            }
            this.interceptor = new MQTransactionInterceptor(methodMap);
            if (!AopUtils.isAopProxy((Object)bean)) {
                bean = super.wrapIfNecessary(bean, beanName, cacheKey);
            } else {
                Advisor[] advisor;
                AdvisedSupport advised = AopUtil.getAdvisedSupport(bean);
                for (Advisor avr : advisor = this.buildAdvisors(beanName, this.getAdvicesAndAdvisorsForBean(null, null, null))) {
                    advised.addAdvisor(0, avr);
                }
            }
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class aClass, String s, TargetSource targetSource) throws BeansException {
        return new Object[]{this.interceptor};
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent == null || applicationEvent instanceof ContextRefreshedEvent) {
            // empty if block
        }
        if (this.enableTransaction) {
            this.init();
        }
    }
}

