/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.MessageSelector;
import com.aliyun.openservices.ons.api.exactlyonce.ExactlyOnceCheckSendbackHook;
import com.aliyun.openservices.ons.api.exactlyonce.ExactlyOnceConsumer;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.LocalTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.aop.proxy.InternalCallback;
import com.aliyun.openservices.ons.api.exactlyonce.aop.proxy.ProxyTxExecuter;
import com.aliyun.openservices.ons.api.exactlyonce.manager.MetricService;
import com.aliyun.openservices.ons.api.exactlyonce.manager.TransactionManager;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.TxContextUtil;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSConsumerAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.reporter.ConsumerStatusReporter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.DefaultConsumerRetryStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.RetryStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ExactlyOnceConsumerImpl
extends ONSConsumerAbstract
implements ExactlyOnceConsumer {
    private static final String TRUE = "true";
    private final ConcurrentHashMap<String, MessageListener> subscribeTable = new ConcurrentHashMap();
    private boolean exactlyOnceDelivery = false;

    public ExactlyOnceConsumerImpl(Properties properties) {
        this(properties, new DefaultConsumerRetryStrategy());
    }

    public ExactlyOnceConsumerImpl(Properties properties, RetryStrategy retryStrategy) {
        super(properties, retryStrategy);
        String suspendTimeMillis = properties.getProperty("suspendTimeMillis");
        if (!UtilAll.isBlank(suspendTimeMillis)) {
            try {
                this.defaultMQPushConsumer.setSuspendCurrentQueueTimeMillis(Long.parseLong(suspendTimeMillis));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.defaultMQPushConsumer.setConsumerStatusReporter(new ExactlyOnceConsumerStatusReporter());
        this.exactlyOnceDelivery = Boolean.parseBoolean(properties.getProperty("exactlyOnceDelivery", TRUE));
        boolean bl = this.exactlyOnceDelivery = this.exactlyOnceDelivery && Boolean.parseBoolean(System.getProperty("exactlyOnceDelivery", TRUE));
        if (this.exactlyOnceDelivery) {
            TransactionManager.start(properties);
        }
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new MessageConsumerExactlyOnceImpl());
        super.start();
        this.registerConsumerToManager();
    }

    private void registerConsumerToManager() {
        TransactionManager.addConsumer(this.defaultMQPushConsumer.getConsumerGroup(), this.defaultMQPushConsumer);
    }

    @Override
    public void subscribe(String topic, String subExpression, MessageListener listener) {
        if (null == topic) {
            throw new ONSClientException("topic is null");
        }
        if (null == listener) {
            throw new ONSClientException("listener is null");
        }
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, subExpression);
    }

    @Override
    public void subscribe(String topic, MessageSelector selector, MessageListener listener) {
        if (null == topic) {
            throw new ONSClientException("topic is null");
        }
        if (null == listener) {
            throw new ONSClientException("listener is null");
        }
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, selector);
    }

    class ExactlyOnceConsumerStatusReporter
    implements ConsumerStatusReporter {
        ExactlyOnceConsumerStatusReporter() {
        }

        @Override
        public Map<String, String> reportStatus() {
            return MetricService.getInstance().getCurrentConsumeStatus();
        }
    }

    class MessageConsumerExactlyOnceImpl
    implements MessageListenerConcurrently {
        MessageConsumerExactlyOnceImpl() {
        }

        @Override
        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msglist, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
            MessageExt msgRMQ = msglist.get(0);
            String consumerGroup = ExactlyOnceConsumerImpl.this.defaultMQPushConsumer.getConsumerGroup();
            String internalMsgId = TxContextUtil.buildInternalMsgId(msgRMQ, consumerGroup);
            final Message msg = ONSUtil.msgConvert(msgRMQ);
            msg.setMsgID(msgRMQ.getMsgId());
            final MessageListener listener = (MessageListener)ExactlyOnceConsumerImpl.this.subscribeTable.get(msg.getTopic());
            if (null == listener) {
                throw new ONSClientException("MessageListener is null");
            }
            final ConsumeContext context = new ConsumeContext();
            MQTxContext txContext = LocalTxContext.get();
            if (txContext == null) {
                txContext = new MQTxContext();
            }
            txContext.setMessageId(internalMsgId);
            txContext.setConsumerGroup(consumerGroup);
            txContext.setOffset(msgRMQ.getQueueOffset());
            txContext.setTopicName(consumeConcurrentlyContext.getMessageQueue().getTopic());
            txContext.setMessageExt(msgRMQ);
            txContext.setMessageQueue(consumeConcurrentlyContext.getMessageQueue());
            LocalTxContext.set(txContext);
            Action action = null;
            action = ExactlyOnceConsumerImpl.this.exactlyOnceDelivery ? (Action)((Object)ProxyTxExecuter.getInstance().excute(new InternalCallback(){

                @Override
                public Object run() {
                    return listener.consume(msg, context);
                }
            })) : listener.consume(msg, context);
            MetricService.getInstance().record(txContext);
            consumeConcurrentlyContext.setCheckSendBackHook(new ExactlyOnceCheckSendbackHook(consumerGroup, txContext.getDataSourceConfig()));
            consumeConcurrentlyContext.setExactlyOnceStatus(TxContextUtil.getExactlyOnceStatus(txContext));
            LocalTxContext.clear();
            Object status = null;
            if (action != null) {
                switch (action) {
                    case CommitMessage: {
                        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                    }
                    case ReconsumeLater: {
                        return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                    }
                }
            }
            return null;
        }
    }
}

