/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.exactlyonce;

import com.aliyun.openservices.ons.api.exactlyonce.aop.model.MQTxContext;
import com.aliyun.openservices.ons.api.exactlyonce.datasource.DataSourceConfig;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.DBAccessUtil;
import com.aliyun.openservices.ons.api.exactlyonce.manager.util.TxContextUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.CheckSendBackHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;

public class ExactlyOnceCheckSendbackHook
implements CheckSendBackHook {
    private String consumerGroup;
    private DataSourceConfig config;

    public ExactlyOnceCheckSendbackHook(String consumerGroup, DataSourceConfig config) {
        this.consumerGroup = consumerGroup;
        this.config = config;
    }

    public DataSourceConfig getConfig() {
        return this.config;
    }

    public void setConfig(DataSourceConfig config) {
        this.config = config;
    }

    @Override
    public String hookName() {
        return "ExactlyOnceCheckSendbackHook";
    }

    @Override
    public boolean needSendBack(MessageExt msg, ConsumeConcurrentlyContext context) {
        if (this.consumerGroup == null || this.config == null) {
            return true;
        }
        MQTxContext txContext = new MQTxContext();
        txContext.setMessageId(TxContextUtil.buildInternalMsgId(msg, this.consumerGroup));
        txContext.setDataSourceConfig(this.config);
        return !DBAccessUtil.isRecordExist(txContext);
    }
}

