package com.aliyun.mns.model.serialize.commonbuy;

import com.aliyun.mns.model.response.commonbuy.OpenServiceResponse;
import com.aliyun.mns.model.serialize.topic.AbstractTopicMetaDeserializer;
import java.io.InputStream;
import org.w3c.dom.Document;

import static com.aliyun.mns.common.MNSConstants.OPEN_SERVICE_ORDER_TAG;

public class OpenServiceResponseDeserializer extends AbstractTopicMetaDeserializer<OpenServiceResponse> {

    @Override
    public OpenServiceResponse deserialize(InputStream stream) throws Exception {
        Document doc = getDocmentBuilder().parse(stream);
        OpenServiceResponse response = new OpenServiceResponse();
        response.setOrderId(safeGetElementContent(doc.getDocumentElement(), OPEN_SERVICE_ORDER_TAG, ""));

        return response;
    }
}
