/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.table.client;

import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.BuiltInConnectionProperty;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.DriverVersion;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.HADriver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class Driver
extends HADriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:lindorm:table:";
    public static final String JDBC_PROTOCOL_TERMINATOR = ";";
    public static final String PROPERTY_SEPARATOR = "=";
    private static final String DEFAULT_SERIALIZATION = "PROTOBUF";
    private static final String DEFAULT_ENDPOINT = "/api/v2/avatica";

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "com-aliyun-lindorm-table-jdbc.properties", "Lindorm Table JDBC Driver", "unknown version", "Lindorm Table", "unknown version");
    }

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    public Connection connect(String url, Properties userInfo) throws SQLException {
        Properties info = new Properties(userInfo);
        info.putAll((Map<?, ?>)userInfo);
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (!this.hasUsernameAndPassword(info)) {
            throw new SQLException("user and password can't be null");
        }
        String prefix = this.getConnectStringPrefix();
        String urlSuffix = url.substring(prefix.length());
        info.putAll((Map<?, ?>)this.readExtraConfigFromUrl(urlSuffix));
        String urlString = info.getProperty(BuiltInConnectionProperty.URL.camelName());
        if (urlString != null && !urlString.contains(DEFAULT_ENDPOINT)) {
            info.put(BuiltInConnectionProperty.URL.camelName(), urlString + DEFAULT_ENDPOINT);
        }
        info.put(BuiltInConnectionProperty.SERIALIZATION.camelName(), DEFAULT_SERIALIZATION);
        this.setConnectionInfo(info);
        Connection conn = super.connect(CONNECT_STRING_PREFIX, info);
        String schemaName = info.getProperty(BuiltInConnectionProperty.SCHEMA.camelName());
        if (schemaName != null) {
            conn.setSchema(schemaName);
        }
        return conn;
    }

    private Properties readExtraConfigFromUrl(String url) {
        String[] kvs;
        Properties info = new Properties();
        for (String kv : kvs = url.split(JDBC_PROTOCOL_TERMINATOR)) {
            String[] fields = kv.split(PROPERTY_SEPARATOR);
            if (fields.length != 2) continue;
            info.put(fields[0].trim(), fields[1].trim());
        }
        return info;
    }

    static {
        new Driver().register();
    }
}

