/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.pool;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.DruidDataSourceFactory;
import com.aliyun.lindorm.pool.LindormDataSource;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;

public class LindormDataSourceFactory
implements ObjectFactory {
    public static final String INIT_KEY = "init";
    public static final String INITIAL_SIZE_KEY = "initialSize";
    public static final String MIN_IDLE_KEY = "minIdle";
    public static final String MAX_ACTIVE_KEY = "maxActive";
    public static final String MAX_WAIT_KEY = "maxWait";
    public static final String KEEP_ALIVE_KEY = "druid.keepAlive";
    public static final String KEEP_ALIVE_BETWEEN_TIME_MILLIS_KEY = "druid.keepAliveBetweenTimeMillis";
    public static final String MIN_EVICTABLE_IDLE_TIME_MILLIS_KEY = "minEvictableIdleTimeMillis";
    public static final String MAX_EVICTABLE_IDLE_TIME_MILLIS_KEY = "maxEvictableIdleTimeMillis";
    public static final String TIME_BETWEEN_EVICTION_RUNS_MILLIS_KEY = "timeBetweenEvictionRunsMillis";
    public static final String VALIDATION_QUERY_KEY = "validationQuery";
    public static final String TEST_WHILE_IDLE_KEY = "testWhileIdle";
    public static final String TEST_ON_BORROW_KEY = "testOnBorrow";
    public static final String TEST_ON_RETURN_KEY = "testOnReturn";
    public static final String POOL_PREPARED_STATEMENTS_KEY = "poolPreparedStatements";
    public static final String MAX_OPEN_PREPARED_STATEMENTS_KEY = "maxOpenPreparedStatements";
    public static final String MAX_POOL_PREPARED_STATEMENT_PER_CONNECTION_SIZE_KEY = "druid.maxPoolPreparedStatementPerConnectionSize";
    private DruidDataSourceFactory underlying = new DruidDataSourceFactory();

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        return this.underlying.getObjectInstance(obj, name, nameCtx, environment);
    }

    public static DataSource createDataSource(Properties properties) throws Exception {
        return LindormDataSourceFactory.createDataSource((Map)properties);
    }

    public static DataSource createDataSource(Map properties) throws Exception {
        LindormDataSource dataSource = new LindormDataSource();
        LindormDataSourceFactory.setDefaultValues(properties);
        DruidDataSourceFactory.config(dataSource, properties);
        return dataSource;
    }

    private static void setDefaultValues(Map properties) {
        LindormDataSourceFactory.setInitDefaultValues(properties);
        LindormDataSourceFactory.setKeepAliveValues(properties);
        LindormDataSourceFactory.setPreparedStatementsDefaultValues(properties);
    }

    private static void setInitDefaultValues(Map properties) {
        if (!properties.containsKey(INIT_KEY)) {
            properties.put(INIT_KEY, "true");
        }
        if (!properties.containsKey(INITIAL_SIZE_KEY)) {
            properties.put(INITIAL_SIZE_KEY, "2");
        }
        if (!properties.containsKey(MIN_IDLE_KEY)) {
            properties.put(MIN_IDLE_KEY, "2");
        }
        if (!properties.containsKey(MAX_ACTIVE_KEY)) {
            properties.put(MAX_ACTIVE_KEY, "5");
        }
        if (!properties.containsKey(MAX_WAIT_KEY)) {
            properties.put(MAX_WAIT_KEY, "30000");
        }
    }

    private static void setKeepAliveValues(Map properties) {
        if (!properties.containsKey(KEEP_ALIVE_KEY)) {
            properties.put(KEEP_ALIVE_KEY, "true");
        }
        if (!properties.containsKey(KEEP_ALIVE_BETWEEN_TIME_MILLIS_KEY)) {
            properties.put(KEEP_ALIVE_BETWEEN_TIME_MILLIS_KEY, "30000");
        }
        if (!properties.containsKey(MIN_EVICTABLE_IDLE_TIME_MILLIS_KEY)) {
            properties.put(MIN_EVICTABLE_IDLE_TIME_MILLIS_KEY, "600000");
        }
        if (!properties.containsKey(MAX_EVICTABLE_IDLE_TIME_MILLIS_KEY)) {
            properties.put(MAX_EVICTABLE_IDLE_TIME_MILLIS_KEY, "900000");
        }
        if (!properties.containsKey(TIME_BETWEEN_EVICTION_RUNS_MILLIS_KEY)) {
            properties.put(TIME_BETWEEN_EVICTION_RUNS_MILLIS_KEY, "5000");
        }
        if (!properties.containsKey(VALIDATION_QUERY_KEY)) {
            properties.put(VALIDATION_QUERY_KEY, "SELECT 1");
        }
        if (!properties.containsKey(TEST_WHILE_IDLE_KEY)) {
            properties.put(TEST_WHILE_IDLE_KEY, "true");
        }
        if (!properties.containsKey(TEST_ON_BORROW_KEY)) {
            properties.put(TEST_ON_BORROW_KEY, "false");
        }
        if (!properties.containsKey(TEST_ON_RETURN_KEY)) {
            properties.put(TEST_ON_RETURN_KEY, "false");
        }
    }

    private static void setPreparedStatementsDefaultValues(Map properties) {
        if (!properties.containsKey(POOL_PREPARED_STATEMENTS_KEY)) {
            properties.put(POOL_PREPARED_STATEMENTS_KEY, "false");
        }
        if (!properties.containsKey(MAX_OPEN_PREPARED_STATEMENTS_KEY)) {
            properties.put(MAX_OPEN_PREPARED_STATEMENTS_KEY, "-1");
        }
        if (!properties.containsKey(MAX_POOL_PREPARED_STATEMENT_PER_CONNECTION_SIZE_KEY)) {
            properties.put(MAX_POOL_PREPARED_STATEMENT_PER_CONNECTION_SIZE_KEY, "-1");
        }
    }
}

