/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote;

import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.AvaticaConnection;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.ConnectionConfig;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.Driver;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.FailoverRetryPolicy;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.HARemoteProtobufService;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.MockJsonService;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.RemoteProtobufService;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.RemoteService;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.Service;
import java.util.Collections;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HADriver
extends Driver {
    private static final Logger LOG = LoggerFactory.getLogger(HADriver.class);
    private Properties connectionInfo = new Properties();
    private static final String FAILOVER_NAME = "failover";
    private static final String DEFULT_FAILOVER_VALUE = "true";
    private static final String MAX_RETRIES_NAME = "maxRetries";
    private static final String INTERVAL_MILLIS_NAME = "interval";
    private static final String MAX_DELAY_NAME = "maxDelay";
    private static final Integer DEFAULT_MAX_RETRIES = 6;
    private static final Integer DEFAULT_MAX_DELAY_BASE = 15000;
    private static final Integer DEFAULT_INTERVAL_MILLIS = 500;
    public static final String LINDORM_TSDB_DRIVER_CONNECT_TIMEOUT = "lindorm.tsdb.driver.connect.timeout";
    public static final String DEFAULT_LINDORM_TSDB_DRIVER_CONNECT_TIMEOUT = "60000";
    public static final String LINDORM_TSDB_DRIVER_CONNECTION_REQUEST_TIMEOUT = "lindorm.tsdb.driver.connection.request.timeout";
    public static final String DEFAULT_LINDORM_TSDB_DRIVER_CONNECTION_REQUEST_TIMEOUT = "60000";
    public static final String LINDORM_TSDB_DRIVER_SOCKET_TIMEOUT = "lindorm.tsdb.driver.socket.timeout";
    public static final String DEFAULT_LINDORM_TSDB_DRIVER_SOCKET_TIMEOUT = "-1";
    public static final String LINDORM_TSDB_DRIVER_HTTP_COMPRESSION = "lindorm.tsdb.driver.http.compression";
    public static final String DEFAULT_LINDORM_TSDB_DRIVER_HTTP_COMPRESSION = "false";

    @Override
    Service createService(AvaticaConnection connection, ConnectionConfig config) {
        Service service;
        Service.Factory metaFactory = config.factory();
        if (metaFactory != null) {
            service = metaFactory.create(connection);
        } else if (config.url() != null) {
            AvaticaHttpClient httpClient = this.getHttpClient(connection, config);
            Driver.Serialization serializationType = this.getSerialization(config);
            boolean failover = Boolean.valueOf(this.connectionInfo.getProperty(FAILOVER_NAME, DEFULT_FAILOVER_VALUE));
            LOG.debug("Instantiating {} service", (Object)serializationType);
            switch (serializationType) {
                case JSON: {
                    service = new RemoteService(httpClient);
                    break;
                }
                case PROTOBUF: {
                    if (failover) {
                        int maxRetries = Integer.valueOf(this.connectionInfo.getProperty(MAX_RETRIES_NAME, DEFAULT_MAX_RETRIES.toString()));
                        int intervalMills = Integer.valueOf(this.connectionInfo.getProperty(INTERVAL_MILLIS_NAME, DEFAULT_INTERVAL_MILLIS.toString()));
                        int maxDelay = Integer.valueOf(this.connectionInfo.getProperty(MAX_DELAY_NAME, DEFAULT_MAX_DELAY_BASE.toString()));
                        FailoverRetryPolicy retryPolicy = new FailoverRetryPolicy(maxRetries, intervalMills, maxDelay);
                        service = new HARemoteProtobufService(this.connectionInfo, httpClient, new ProtobufTranslationImpl(), retryPolicy);
                        break;
                    }
                    service = new RemoteProtobufService(httpClient, new ProtobufTranslationImpl());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled serialization type: " + (Object)((Object)serializationType));
                }
            }
        } else {
            service = new MockJsonService(Collections.emptyMap());
        }
        return service;
    }

    public void setConnectionInfo(Properties connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    protected boolean hasUsernameAndPassword(Properties connectionInfo) {
        return connectionInfo.getProperty("user") != null && connectionInfo.getProperty("password") != null;
    }

    static {
        new HADriver().register();
    }
}

