/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote;

import com.aliyun.lindorm.client.shaded.org.apache.http.conn.ConnectTimeoutException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverRetryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverRetryPolicy.class);
    private int maxRetries;
    private long intervalMillis;
    private long maxDelayBase;
    private int retries = 0;

    public FailoverRetryPolicy(int maxRetries, long intervalMillis, long maxDelayBase) {
        this.maxRetries = maxRetries;
        this.intervalMillis = intervalMillis;
        this.maxDelayBase = maxDelayBase;
    }

    private long getRetrySleepTime(int times) {
        return Math.min(this.intervalMillis * (1L << times), this.maxDelayBase);
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean awaitUntilNextRetry(Throwable e) {
        if (this.retries > this.maxRetries) {
            LOG.warn("retries (" + this.retries + ") exceeded maximum allowed (" + this.maxRetries + ")");
            throw new IllegalStateException("retries (" + this.retries + ") exceeded maximum allowed (" + this.maxRetries + ")");
        }
        if (e instanceof ConnectException || e instanceof NoRouteToHostException || e instanceof UnknownHostException || e instanceof ConnectTimeoutException || e instanceof SocketException) {
            long sleepTime = this.getRetrySleepTime(this.retries);
            if (sleepTime <= 0L) {
                throw new IllegalArgumentException("retry interval times must be greater than 0");
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e1) {
                LOG.warn("retries (" + this.retries + ") was Interrupted", (Throwable)e1);
            }
            ++this.retries;
            return true;
        }
        return false;
    }
}

