/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote;

import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.ColumnMetaData;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.Meta;
import com.aliyun.lindorm.client.shaded.org.apache.calcite.avatica.remote.Service;
import java.util.ArrayList;

public abstract class AbstractService
implements Service {
    private Service.RpcMetadataResponse rpcMetadata = null;

    abstract SerializationType getSerializationType();

    Meta.Signature finagle(Meta.Signature signature) {
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        for (ColumnMetaData column : signature.columns) {
            columns.add(this.finagle(column));
        }
        if (columns.equals(signature.columns)) {
            return signature;
        }
        return new Meta.Signature(columns, signature.sql, signature.parameters, signature.internalParameters, signature.cursorFactory, signature.statementType);
    }

    ColumnMetaData finagle(ColumnMetaData column) {
        switch (column.type.rep) {
            case BYTE: 
            case PRIMITIVE_BYTE: 
            case DOUBLE: 
            case PRIMITIVE_DOUBLE: 
            case FLOAT: 
            case PRIMITIVE_FLOAT: 
            case INTEGER: 
            case PRIMITIVE_INT: 
            case SHORT: 
            case PRIMITIVE_SHORT: 
            case LONG: 
            case PRIMITIVE_LONG: {
                return column.setRep(ColumnMetaData.Rep.NUMBER);
            }
        }
        switch (column.type.id) {
            case -3: 
            case -2: {
                switch (this.getSerializationType()) {
                    case JSON: {
                        return column.setRep(ColumnMetaData.Rep.STRING);
                    }
                    case PROTOBUF: {
                        return column;
                    }
                }
                throw new IllegalStateException("Unhadled case statement");
            }
            case 2: 
            case 3: {
                return column.setRep(ColumnMetaData.Rep.NUMBER);
            }
        }
        return column;
    }

    Service.PrepareResponse finagle(Service.PrepareResponse response) {
        Meta.StatementHandle statement = this.finagle(response.statement);
        if (statement == response.statement) {
            return response;
        }
        return new Service.PrepareResponse(statement, this.rpcMetadata);
    }

    Meta.StatementHandle finagle(Meta.StatementHandle h) {
        Meta.Signature signature = this.finagle(h.signature);
        if (signature == h.signature) {
            return h;
        }
        return new Meta.StatementHandle(h.connectionId, h.id, signature);
    }

    Service.ResultSetResponse finagle(Service.ResultSetResponse r) {
        if (r.updateCount != -1L) {
            assert (r.signature == null);
            return r;
        }
        if (r.signature == null) {
            return r;
        }
        Meta.Signature signature = this.finagle(r.signature);
        if (signature == r.signature) {
            return r;
        }
        return new Service.ResultSetResponse(r.connectionId, r.statementId, r.ownStatement, signature, r.firstFrame, r.updateCount, this.rpcMetadata);
    }

    Service.ExecuteResponse finagle(Service.ExecuteResponse r) {
        if (r.missingStatement) {
            return r;
        }
        ArrayList<Service.ResultSetResponse> results = new ArrayList<Service.ResultSetResponse>();
        int changeCount = 0;
        for (Service.ResultSetResponse result : r.results) {
            Service.ResultSetResponse result2 = this.finagle(result);
            if (result2 != result) {
                ++changeCount;
            }
            results.add(result2);
        }
        if (changeCount == 0) {
            return r;
        }
        return new Service.ExecuteResponse(results, r.missingStatement, this.rpcMetadata);
    }

    @Override
    public void setRpcMetadata(Service.RpcMetadataResponse metadata) {
        this.rpcMetadata = metadata;
    }

    static enum SerializationType {
        JSON,
        PROTOBUF;

    }
}

