/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.util;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.FnvHash;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.HexBin;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.JdbcUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Set;

public class Utils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static Date startTime;

    public static String read(InputStream in) {
        InputStreamReader reader;
        if (in == null) {
            return null;
        }
        try {
            reader = new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return Utils.read(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromResource(String resource) throws IOException {
        String text;
        InputStream in;
        block5: {
            String string;
            if (resource == null || resource.isEmpty() || resource.contains("..") || resource.contains("?") || resource.contains(":")) {
                return null;
            }
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in == null) {
                    in = Utils.class.getResourceAsStream(resource);
                }
                if (in != null) break block5;
                string = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(in);
                throw throwable;
            }
            JdbcUtils.close(in);
            return string;
        }
        String string = text = Utils.read(in);
        JdbcUtils.close(in);
        return string;
    }

    public static byte[] readByteArrayFromResource(String resource) throws IOException {
        InputStream in;
        block4: {
            byte[] byArray;
            if (resource == null || resource.isEmpty() || resource.contains("..") || resource.contains("?") || resource.contains(":")) {
                return null;
            }
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in != null) break block4;
                byArray = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(in);
                throw throwable;
            }
            JdbcUtils.close(in);
            return byArray;
        }
        byte[] byArray = Utils.readByteArray(in);
        JdbcUtils.close(in);
        return byArray;
    }

    public static byte[] readByteArray(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Utils.copy(input, output);
        byte[] bytes = output.toByteArray();
        output.close();
        return bytes;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int EOF = -1;
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String read(Reader reader) {
        if (reader == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String read(Reader reader, int length) {
        if (reader == null) {
            return null;
        }
        try {
            int len;
            char[] buffer = new char[length];
            int offset = 0;
            int rest = length;
            while ((len = reader.read(buffer, offset, rest)) != -1) {
                offset += len;
                if ((rest -= len) != 0) continue;
            }
            return new String(buffer, 0, length - rest);
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String toString(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter buf = new StringWriter();
        ex.printStackTrace(new PrintWriter(buf));
        return buf.toString();
    }

    public static String toString(StackTraceElement[] stackTrace) {
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement item : stackTrace) {
            buf.append(item.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public static Boolean getBoolean(Properties properties, String key) {
        String property = properties.getProperty(key);
        if ("true".equals(property)) {
            return Boolean.TRUE;
        }
        if ("false".equals(property)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Integer getInteger(Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            return null;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Long getLong(Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            return null;
        }
        try {
            return Long.parseLong(property);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Class<?> loadClass(String className) {
        Class<?> clazz = null;
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
            if (ctxClassLoader != null) {
                try {
                    clazz = ctxClassLoader.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            return clazz;
        }
    }

    public static final Date getStartTime() {
        if (startTime == null) {
            startTime = new Date(ManagementFactory.getRuntimeMXBean().getStartTime());
        }
        return startTime;
    }

    public static long murmurhash2_64(String text) {
        byte[] bytes = text.getBytes();
        return Utils.murmurhash2_64(bytes, bytes.length, -512093083);
    }

    public static long murmurhash2_64(byte[] data, int length, int seed) {
        long m = -4132994306676758123L;
        int r = 47;
        long h = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int length8 = length / 8;
        for (int i = 0; i < length8; ++i) {
            int i8 = i * 8;
            long k = ((long)data[i8 + 0] & 0xFFL) + (((long)data[i8 + 1] & 0xFFL) << 8) + (((long)data[i8 + 2] & 0xFFL) << 16) + (((long)data[i8 + 3] & 0xFFL) << 24) + (((long)data[i8 + 4] & 0xFFL) << 32) + (((long)data[i8 + 5] & 0xFFL) << 40) + (((long)data[i8 + 6] & 0xFFL) << 48) + (((long)data[i8 + 7] & 0xFFL) << 56);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        switch (length % 8) {
            case 7: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= (long)(data[length & 0xFFFFFFF8] & 0xFF);
                h *= -4132994306676758123L;
            }
        }
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return h;
    }

    public static byte[] md5Bytes(String text) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("System doesn't support MD5 algorithm.");
        }
        msgDigest.update(text.getBytes());
        byte[] bytes = msgDigest.digest();
        return bytes;
    }

    public static String md5(String text) {
        byte[] bytes = Utils.md5Bytes(text);
        return HexBin.encode(bytes, false);
    }

    public static void putLong(byte[] b, int off, long val) {
        b[off + 7] = (byte)(val >>> 0);
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off + 0] = (byte)(val >>> 56);
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static String hex(int hash) {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)hash;
        bytes[2] = (byte)(hash >>> 8);
        bytes[1] = (byte)(hash >>> 16);
        bytes[0] = (byte)(hash >>> 24);
        char[] chars = new char[8];
        for (int i = 0; i < 4; ++i) {
            byte b = bytes[i];
            int a = b & 0xFF;
            int b0 = a >> 4;
            int b1 = a & 0xF;
            chars[i * 2] = (char)(b0 + (b0 < 10 ? 48 : 55));
            chars[i * 2 + 1] = (char)(b1 + (b1 < 10 ? 48 : 55));
        }
        return new String(chars);
    }

    public static String hex(long hash) {
        byte[] bytes = new byte[8];
        bytes[7] = (byte)hash;
        bytes[6] = (byte)(hash >>> 8);
        bytes[5] = (byte)(hash >>> 16);
        bytes[4] = (byte)(hash >>> 24);
        bytes[3] = (byte)(hash >>> 32);
        bytes[2] = (byte)(hash >>> 40);
        bytes[1] = (byte)(hash >>> 48);
        bytes[0] = (byte)(hash >>> 56);
        char[] chars = new char[16];
        for (int i = 0; i < 8; ++i) {
            byte b = bytes[i];
            int a = b & 0xFF;
            int b0 = a >> 4;
            int b1 = a & 0xF;
            chars[i * 2] = (char)(b0 + (b0 < 10 ? 48 : 55));
            chars[i * 2 + 1] = (char)(b1 + (b1 < 10 ? 48 : 55));
        }
        return new String(chars);
    }

    public static String hex_t(long hash) {
        byte[] bytes = new byte[8];
        bytes[7] = (byte)hash;
        bytes[6] = (byte)(hash >>> 8);
        bytes[5] = (byte)(hash >>> 16);
        bytes[4] = (byte)(hash >>> 24);
        bytes[3] = (byte)(hash >>> 32);
        bytes[2] = (byte)(hash >>> 40);
        bytes[1] = (byte)(hash >>> 48);
        bytes[0] = (byte)(hash >>> 56);
        char[] chars = new char[18];
        chars[0] = 84;
        chars[1] = 95;
        for (int i = 0; i < 8; ++i) {
            byte b = bytes[i];
            int a = b & 0xFF;
            int b0 = a >> 4;
            int b1 = a & 0xF;
            chars[i * 2 + 2] = (char)(b0 + (b0 < 10 ? 48 : 55));
            chars[i * 2 + 3] = (char)(b1 + (b1 < 10 ? 48 : 55));
        }
        return new String(chars);
    }

    public static long fnv_64(String input) {
        return FnvHash.fnv1a_64(input);
    }

    public static long fnv_64_lower(String key) {
        return FnvHash.fnv1a_64_lower(key);
    }

    public static long fnv_32_lower(String key) {
        return FnvHash.fnv_32_lower(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void loadFromFile(String path, Set<String> set) {
        InputStream is = null;
        BufferedReader reader = null;
        try {
            String line;
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim().toLowerCase()).length() == 0) continue;
                set.add(line);
            }
        }
        catch (Exception exception) {
            JdbcUtils.close(is);
            JdbcUtils.close(reader);
            catch (Throwable throwable) {
                JdbcUtils.close(is);
                JdbcUtils.close(reader);
                throw throwable;
            }
        }
        JdbcUtils.close(is);
        JdbcUtils.close(reader);
    }
}

