/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ListDG {
    private List<VNode> mVexs;

    public ListDG(List vexs, List<Edge> edges) {
        int i;
        int vlen = vexs.size();
        int elen = edges.size();
        this.mVexs = new ArrayList<VNode>();
        for (i = 0; i < vlen; ++i) {
            VNode vnode = new VNode();
            vnode.data = vexs.get(i);
            vnode.firstEdge = null;
            this.mVexs.add(vnode);
        }
        for (i = 0; i < elen; ++i) {
            Object c1 = edges.get((int)i).from;
            Object c2 = edges.get((int)i).to;
            int p1 = this.getPosition(edges.get((int)i).from);
            int p2 = this.getPosition(edges.get((int)i).to);
            ENode node1 = new ENode();
            node1.ivex = p2;
            if (this.mVexs.get((int)p1).firstEdge == null) {
                this.mVexs.get((int)p1).firstEdge = node1;
                continue;
            }
            this.linkLast(this.mVexs.get((int)p1).firstEdge, node1);
        }
    }

    private void linkLast(ENode list, ENode node) {
        ENode p = list;
        while (p.nextEdge != null) {
            p = p.nextEdge;
        }
        p.nextEdge = node;
    }

    private int getPosition(Object ch) {
        for (int i = 0; i < this.mVexs.size(); ++i) {
            if (this.mVexs.get((int)i).data != ch) continue;
            return i;
        }
        return -1;
    }

    private void DFS(int i, boolean[] visited) {
        visited[i] = true;
        ENode node = this.mVexs.get((int)i).firstEdge;
        while (node != null) {
            if (!visited[node.ivex]) {
                this.DFS(node.ivex, visited);
            }
            node = node.nextEdge;
        }
    }

    public void DFS() {
        int i;
        boolean[] visited = new boolean[this.mVexs.size()];
        for (i = 0; i < this.mVexs.size(); ++i) {
            visited[i] = false;
        }
        for (i = 0; i < this.mVexs.size(); ++i) {
            if (visited[i]) continue;
            this.DFS(i, visited);
        }
    }

    public void BFS() {
        int i;
        int head = 0;
        int rear = 0;
        int[] queue = new int[this.mVexs.size()];
        boolean[] visited = new boolean[this.mVexs.size()];
        for (i = 0; i < this.mVexs.size(); ++i) {
            visited[i] = false;
        }
        for (i = 0; i < this.mVexs.size(); ++i) {
            if (!visited[i]) {
                visited[i] = true;
                System.out.printf("%c ", this.mVexs.get((int)i).data);
                queue[rear++] = i;
            }
            while (head != rear) {
                int j = queue[head++];
                ENode node = this.mVexs.get((int)j).firstEdge;
                while (node != null) {
                    int k = node.ivex;
                    if (!visited[k]) {
                        visited[k] = true;
                        System.out.printf("%c ", this.mVexs.get((int)k).data);
                        queue[rear++] = k;
                    }
                    node = node.nextEdge;
                }
            }
        }
    }

    public void print() {
        System.out.printf("== List Graph:\n", new Object[0]);
        for (int i = 0; i < this.mVexs.size(); ++i) {
            System.out.printf("%d(%c): ", i, this.mVexs.get((int)i).data);
            ENode node = this.mVexs.get((int)i).firstEdge;
            while (node != null) {
                System.out.printf("%d(%c) ", node.ivex, this.mVexs.get((int)node.ivex).data);
                node = node.nextEdge;
            }
        }
    }

    public boolean topologicalSort() {
        return this.topologicalSort(new Object[this.mVexs.size()]);
    }

    public boolean topologicalSort(Object[] tops) {
        ENode node;
        int i;
        int index = 0;
        int num = this.mVexs.size();
        int[] ins = new int[num];
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (i = 0; i < num; ++i) {
            node = this.mVexs.get((int)i).firstEdge;
            while (node != null) {
                int n = node.ivex;
                ins[n] = ins[n] + 1;
                node = node.nextEdge;
            }
        }
        for (i = 0; i < num; ++i) {
            if (ins[i] != 0) continue;
            queue.offer(i);
        }
        while (!queue.isEmpty()) {
            int j = (Integer)queue.poll();
            tops[index++] = this.mVexs.get((int)j).data;
            node = this.mVexs.get((int)j).firstEdge;
            while (node != null) {
                int n = node.ivex;
                ins[n] = ins[n] - 1;
                if (ins[node.ivex] == 0) {
                    queue.offer(node.ivex);
                }
                node = node.nextEdge;
            }
        }
        return index == num;
    }

    private class VNode {
        Object data;
        ENode firstEdge;

        private VNode() {
        }
    }

    private class ENode {
        int ivex;
        ENode nextEdge;

        private ENode() {
        }
    }

    public static class Edge {
        public Object from;
        public Object to;

        public Edge(Object from, Object to) {
            this.from = from;
            this.to = to;
        }
    }
}

