/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.spring.stat;

import java.lang.reflect.Method;

public class SpringMethodInfo {
    private String signature;
    private Class<?> instanceClass;
    private Method method;

    public SpringMethodInfo(Class<?> instanceClass, Method method) {
        this.instanceClass = instanceClass;
        this.method = method;
    }

    public String getClassName() {
        return this.instanceClass.getName();
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.instanceClass.getName().hashCode();
        result = 31 * result + this.method.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SpringMethodInfo)) {
            return false;
        }
        SpringMethodInfo other = (SpringMethodInfo)obj;
        if (!this.instanceClass.getName().equals(other.instanceClass.getName())) {
            return false;
        }
        if (!this.method.getName().equals(other.method.getName())) {
            return false;
        }
        if (this.method.getParameterTypes().length != other.method.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < this.method.getParameterTypes().length; ++i) {
            if (this.method.getParameterTypes()[i].getName().equals(other.method.getParameterTypes()[i].getName())) continue;
            return false;
        }
        return true;
    }

    public static String getMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName());
        sb.append('(');
        Class<?>[] params = method.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(params[j].getName());
            if (j >= params.length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    public String getSignature() {
        if (this.signature == null) {
            this.signature = SpringMethodInfo.getMethodSignature(this.method);
        }
        return this.signature;
    }
}

