/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.profile;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.profile.ProfileEntryKey;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.profile.ProfileEntryReqStat;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.profile.ProfileEntryStat;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.profile.ProfileEntryStatValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ProfileStat {
    private Map<ProfileEntryKey, ProfileEntryStat> entries = new LinkedHashMap<ProfileEntryKey, ProfileEntryStat>(4);
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public Map<ProfileEntryKey, ProfileEntryStat> getEntries() {
        return this.entries;
    }

    public void record(Map<ProfileEntryKey, ProfileEntryReqStat> requestStatsMap) {
        if (requestStatsMap == null) {
            return;
        }
        for (Map.Entry<ProfileEntryKey, ProfileEntryReqStat> entry : requestStatsMap.entrySet()) {
            ProfileEntryKey entryKey = entry.getKey();
            ProfileEntryReqStat reqEntryStat = entry.getValue();
            ProfileEntryStat entryStat = this.getProfileEntry(entryKey);
            entryStat.addExecuteCount(reqEntryStat.getExecuteCount());
            entryStat.addExecuteTimeNanos(reqEntryStat.getExecuteTimeNanos());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfileEntryStat getProfileEntry(ProfileEntryKey entryKey) {
        ProfileEntryStat entryStat;
        this.lock.readLock().lock();
        try {
            entryStat = this.entries.get(entryKey);
            if (entryStat != null) {
                ProfileEntryStat profileEntryStat = entryStat;
                return profileEntryStat;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            entryStat = this.entries.get(entryKey);
            if (entryStat == null) {
                this.entries.put(entryKey, new ProfileEntryStat());
                entryStat = this.entries.get(entryKey);
            }
            ProfileEntryStat profileEntryStat = entryStat;
            return profileEntryStat;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<Map<String, Object>> getStatData() {
        List<ProfileEntryStatValue> statValueList = this.getStatValue(false);
        int size = statValueList.size();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(size);
        for (ProfileEntryStatValue profileEntryStatValue : statValueList) {
            list.add(profileEntryStatValue.getData());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProfileEntryStatValue> getStatValue(boolean reset) {
        ArrayList<ProfileEntryStatValue> list = new ArrayList<ProfileEntryStatValue>();
        this.lock.readLock().lock();
        try {
            for (Map.Entry<ProfileEntryKey, ProfileEntryStat> entry : this.entries.entrySet()) {
                ProfileEntryStatValue entryStatValue = entry.getValue().getValue(reset);
                entry.getKey().fillValue(entryStatValue);
                list.add(entryStatValue);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        Collections.reverse(list);
        return list;
    }
}

