/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.opds.udf;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.annotation.JSONField;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.DbType;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.SQLUtils;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLLimit;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLName;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLOrderBy;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLOver;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLAlterStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLDropStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.odps.ast.OdpsReadStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.odps.visitor.OdpsASTVisitorAdapter;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.SQLParserFeature;
import com.aliyun.odps.udf.UDF;
import java.util.List;
import java.util.Map;

public class SqlCodeStat
extends UDF {
    public String evaluate(String sql) {
        return this.evaluate(sql, null, false);
    }

    public String evaluate(String sql, String dbTypeName) {
        return this.evaluate(sql, dbTypeName, false);
    }

    public String evaluate(String sql, String dbTypeName, boolean throwError) {
        DbType dbType = dbTypeName == null ? null : DbType.valueOf(dbTypeName);
        try {
            List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, DbType.odps, SQLParserFeature.EnableMultiUnion, SQLParserFeature.EnableSQLBinaryOpExprGroup);
            CodeStatVisitor v = new CodeStatVisitor();
            for (SQLStatement stmt : stmtList) {
                stmt.accept(v);
            }
            return v.toString();
        }
        catch (Exception ex) {
            if (throwError) {
                throw new IllegalArgumentException("error sql : \n" + sql, ex);
            }
            return null;
        }
    }

    static class CodeStatVisitor
    extends OdpsASTVisitorAdapter {
        SqlStat stat = new SqlStat();

        CodeStatVisitor() {
        }

        @Override
        public void preVisit(SQLObject x) {
            if (x instanceof SQLStatement) {
                ++this.stat.statementCount;
                if (x instanceof SQLInsertStatement) {
                    ++this.stat.insert;
                    SQLInsertStatement insert = (SQLInsertStatement)x;
                    if (insert.getQuery() != null) {
                        ++this.stat.insertSelect;
                    }
                    if (insert.isOverwrite()) {
                        ++this.stat.insertOverwrite;
                    } else {
                        ++this.stat.insertInto;
                    }
                } else if (x instanceof HiveMultiInsertStatement) {
                    ++this.stat.insert;
                    ++this.stat.insertMulti;
                    ++this.stat.insertSelect;
                    for (HiveInsert item : ((HiveMultiInsertStatement)x).getItems()) {
                        if (item.isOverwrite()) {
                            ++this.stat.insertOverwrite;
                            continue;
                        }
                        ++this.stat.insertInto;
                    }
                } else if (x instanceof SQLDropStatement) {
                    ++this.stat.drop;
                    if (x instanceof SQLDropTableStatement) {
                        ++this.stat.dropTable;
                    } else if (x instanceof SQLDropViewStatement) {
                        ++this.stat.dropView;
                    }
                } else if (x instanceof SQLCreateStatement) {
                    ++this.stat.create;
                    if (x instanceof SQLCreateTableStatement) {
                        ++this.stat.createTable;
                    } else if (x instanceof SQLCreateViewStatement) {
                        ++this.stat.createView;
                    }
                } else if (x instanceof SQLDeleteStatement) {
                    ++this.stat.delete;
                } else if (x instanceof SQLUpdateStatement) {
                    ++this.stat.update;
                } else if (x instanceof SQLSetStatement) {
                    ++this.stat.set;
                } else if (x instanceof SQLAlterStatement) {
                    ++this.stat.alter;
                } else if (x instanceof OdpsReadStatement) {
                    ++this.stat.read;
                }
            }
        }

        @Override
        public boolean visit(SQLUnionQuery x) {
            ++this.stat.union;
            return true;
        }

        @Override
        public boolean visit(SQLLateralViewTableSource x) {
            ++this.stat.lateralView;
            return true;
        }

        @Override
        public boolean visit(OdpsSelectQueryBlock x) {
            return this.visit((SQLSelectQueryBlock)x);
        }

        @Override
        public boolean visit(SQLSelectQueryBlock x) {
            ++this.stat.select;
            return true;
        }

        @Override
        public boolean visit(SQLSelectGroupByClause x) {
            ++this.stat.groupBy;
            if (x.getHaving() != null) {
                ++this.stat.having;
            }
            return true;
        }

        @Override
        public boolean visit(SQLLimit x) {
            ++this.stat.limit;
            return false;
        }

        @Override
        public boolean visit(SQLWithSubqueryClause.Entry x) {
            ++this.stat.cte;
            return true;
        }

        @Override
        public boolean visit(SQLOrderBy x) {
            ++this.stat.orderBy;
            return true;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            ++this.stat.from;
            return true;
        }

        @Override
        public boolean visit(SQLSubqueryTableSource x) {
            ++this.stat.from;
            ++this.stat.subQuery;
            return true;
        }

        @Override
        public boolean visit(SQLJoinTableSource x) {
            if (!(x.getParent() instanceof SQLJoinTableSource)) {
                ++this.stat.from;
            }
            ++this.stat.join;
            return true;
        }

        @Override
        public boolean visit(SQLMethodInvokeExpr x) {
            ++this.stat.functionCall;
            return true;
        }

        @Override
        public boolean visit(SQLAggregateExpr x) {
            ++this.stat.aggregate;
            return true;
        }

        @Override
        public boolean visit(SQLOver x) {
            ++this.stat.over;
            return true;
        }

        @Override
        public boolean visit(SQLCastExpr x) {
            ++this.stat.functionCall;
            return true;
        }

        @Override
        public boolean visit(SQLInListExpr x) {
            ++this.stat.condition;
            return true;
        }

        @Override
        public boolean visit(SQLBinaryOpExpr x) {
            if (x.getOperator() != null && x.getOperator().isRelational()) {
                ++this.stat.condition;
                SQLExpr left = x.getLeft();
                SQLExpr right = x.getRight();
                if (left instanceof SQLName && right instanceof SQLName) {
                    ++this.stat.joinCondition;
                } else if ((left instanceof SQLName || right instanceof SQLName) && (left instanceof SQLLiteralExpr || right instanceof SQLLiteralExpr)) {
                    ++this.stat.valueCondition;
                } else {
                    ++this.stat.otherCondition;
                }
            }
            return true;
        }

        @Override
        public boolean visit(SQLCaseExpr x) {
            SQLExpr value = x.getValueExpr();
            if (value != null) {
                this.stat.condition += x.getItems().size();
            }
            if (x.getElseExpr() != null) {
                ++this.stat.condition;
            }
            return true;
        }

        @Override
        public boolean visit(SQLExistsExpr x) {
            ++this.stat.condition;
            return true;
        }

        public String toString() {
            return JSON.toJSONString((Object)this.stat, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat, JSONWriter.Feature.NotWriteDefaultValue});
        }

        public Map toMap() {
            return (Map)JSON.toJSON((Object)this.stat);
        }
    }

    public static class SqlStat {
        @JSONField(ordinal=0)
        public int statementCount;
        @JSONField(ordinal=1)
        public int cte;
        @JSONField(ordinal=2)
        public int union;
        @JSONField(ordinal=3)
        public int select;
        @JSONField(ordinal=4)
        public int groupBy;
        @JSONField(ordinal=5)
        public int orderBy;
        @JSONField(ordinal=6)
        public int from;
        @JSONField(ordinal=7)
        public int join;
        @JSONField(ordinal=8)
        public int over;
        @JSONField(ordinal=9)
        public int subQuery;
        @JSONField(ordinal=10)
        public int lateralView;
        @JSONField(ordinal=40)
        public int insert;
        @JSONField(ordinal=41)
        public int insertInto;
        @JSONField(ordinal=42)
        public int insertOverwrite;
        @JSONField(ordinal=43)
        public int insertSelect;
        @JSONField(ordinal=44)
        public int insertMulti;
        @JSONField(ordinal=51)
        public int update;
        @JSONField(ordinal=52)
        public int delete;
        @JSONField(ordinal=60)
        public int create;
        @JSONField(ordinal=61)
        public int createTable;
        @JSONField(ordinal=62)
        public int createView;
        @JSONField(ordinal=70)
        public int drop;
        @JSONField(ordinal=71)
        public int dropTable;
        @JSONField(ordinal=72)
        public int dropView;
        @JSONField(ordinal=80)
        public int set;
        @JSONField(ordinal=90)
        public int alter;
        @JSONField(ordinal=100)
        public int read;
        @JSONField(ordinal=200)
        public int condition;
        @JSONField(ordinal=201)
        public int joinCondition;
        @JSONField(ordinal=202)
        public int valueCondition;
        @JSONField(ordinal=203)
        public int otherCondition;
        @JSONField(ordinal=204)
        public int limit;
        @JSONField(ordinal=300)
        public int aggregate;
        @JSONField(ordinal=201)
        public int functionCall;
        @JSONField(ordinal=202)
        public int having;
    }
}

