/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.monitor;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.DruidDataSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.DruidDataSourceStatValue;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.stat.JdbcSqlStatValue;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.http.stat.WebAppStat;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.http.stat.WebAppStatManager;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.http.stat.WebAppStatValue;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.http.stat.WebURIStatValue;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.Log;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.LogFactory;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.monitor.MonitorContext;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.monitor.dao.MonitorDao;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.spring.stat.SpringMethodStatValue;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.spring.stat.SpringStat;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.spring.stat.SpringStatManager;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.StringUtils;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.Utils;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.wall.WallProviderStatValue;
import java.lang.constant.Constable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MonitorClient {
    private static final Log LOG = LogFactory.getLog(MonitorClient.class);
    private static final long DEFAULT_TIME_BETWEEN_COLLECT = 300L;
    private ScheduledExecutorService scheduler;
    private int schedulerThreadSize = 1;
    private long timeBetweenSqlCollect = 300L;
    private long timeBetweenSpringCollect = 300L;
    private long timeBetweenWebUriCollect = 300L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private boolean collectSqlEnable = true;
    private boolean collectSqlWallEnable = true;
    private boolean collectSpringMethodEnable = true;
    private boolean collectWebAppEnable = true;
    private boolean collectWebURIEnable = true;
    private MonitorDao dao;
    private String domain;
    private String app;
    private String cluster;
    private String host;
    private String ip;
    private int pid;

    public MonitorClient() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] items = name.split("@");
        this.pid = Integer.parseInt(items[0]);
        this.host = items[1];
        this.ip = MonitorClient.getLocalIPAddress().getHostAddress();
        this.configFromProperty(System.getProperties());
    }

    public void configFromProperty(Properties properties) {
        Constable value = Utils.getInteger(properties, "druid.monitor.client.schedulerThreadSize");
        if (value != null) {
            this.setSchedulerThreadSize((Integer)value);
        }
        if ((value = Utils.getInteger(properties, "druid.monitor.client.timeBetweenSqlCollect")) != null) {
            this.setTimeBetweenSqlCollect(((Integer)value).intValue());
        }
        if ((value = Utils.getInteger(properties, "druid.monitor.client.timeBetweenSpringCollect")) != null) {
            this.setTimeBetweenSpringCollect(((Integer)value).intValue());
        }
        if ((value = Utils.getInteger(properties, "druid.monitor.client.timeBetweenWebUriCollect")) != null) {
            this.setTimeBetweenWebUriCollect(((Integer)value).intValue());
        }
        if ((value = Utils.getBoolean(properties, "druid.monitor.client.collectSqlEnable")) != null) {
            this.setCollectSqlEnable((Boolean)value);
        }
        if ((value = Utils.getBoolean(properties, "druid.monitor.client.collectSqlWallEnable")) != null) {
            this.setCollectSqlWallEnable((Boolean)value);
        }
        if ((value = Utils.getBoolean(properties, "druid.monitor.client.collectSpringMethodEnable")) != null) {
            this.setCollectSpringMethodEnable((Boolean)value);
        }
        if ((value = Utils.getBoolean(properties, "druid.monitor.client.collectWebAppEnable")) != null) {
            this.setCollectWebAppEnable((Boolean)value);
        }
        if ((value = Utils.getBoolean(properties, "druid.monitor.client.collectWebURIEnable")) != null) {
            this.setCollectWebURIEnable((Boolean)value);
        }
        this.domain = properties.getProperty("druid.monitor.domain");
        if (StringUtils.isEmpty(this.domain)) {
            this.domain = "default";
        }
        this.app = properties.getProperty("druid.monitor.app");
        if (StringUtils.isEmpty(this.app)) {
            this.app = "default";
        }
        this.cluster = properties.getProperty("druid.monitor.cluster");
        if (StringUtils.isEmpty(this.cluster)) {
            this.cluster = "default";
        }
    }

    public void stop() {
    }

    public void start() {
        this.checkInst();
        if (this.scheduler == null) {
            this.scheduler = new ScheduledThreadPoolExecutor(this.schedulerThreadSize);
        }
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MonitorClient.this.collectSql();
            }
        }, this.timeBetweenSqlCollect, this.timeBetweenSqlCollect, this.timeUnit);
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MonitorClient.this.collectSpringMethod();
            }
        }, this.timeBetweenSpringCollect, this.timeBetweenSpringCollect, this.timeUnit);
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MonitorClient.this.collectWebURI();
            }
        }, this.timeBetweenWebUriCollect, this.timeBetweenWebUriCollect, this.timeUnit);
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public void checkInst() {
        try {
            this.dao.insertAppIfNotExits(this.domain, this.app);
            this.dao.insertClusterIfNotExits(this.domain, this.app, this.cluster);
            this.dao.insertOrUpdateInstance(this.domain, this.app, this.cluster, this.host, this.ip, Utils.getStartTime(), this.pid);
        }
        catch (Exception ex) {
            LOG.error("checkInst error", ex);
        }
    }

    public void collectSql() {
        if (!this.collectSqlEnable && !this.collectSqlWallEnable) {
            return;
        }
        Set<Object> dataSources = DruidDataSourceStatManager.getInstances().keySet();
        ArrayList<DruidDataSourceStatValue> statValueList = new ArrayList<DruidDataSourceStatValue>(dataSources.size());
        ArrayList<WallProviderStatValue> wallStatValueList = new ArrayList<WallProviderStatValue>();
        for (Object item : dataSources) {
            WallProviderStatValue wallStatValue;
            if (!(item instanceof DruidDataSource)) continue;
            DruidDataSource dataSource = (DruidDataSource)item;
            if (this.collectSqlEnable) {
                DruidDataSourceStatValue statValue = dataSource.getStatValueAndReset();
                statValueList.add(statValue);
            }
            if (!this.collectSqlWallEnable || (wallStatValue = dataSource.getWallStatValue(true)) == null || wallStatValue.getCheckCount() <= 0L) continue;
            wallStatValueList.add(wallStatValue);
        }
        MonitorContext ctx = this.createContext();
        if (statValueList.size() > 0) {
            this.dao.saveSql(ctx, statValueList);
        }
        if (wallStatValueList.size() > 0) {
            this.dao.saveSqlWall(ctx, wallStatValueList);
        }
    }

    private MonitorContext createContext() {
        MonitorContext ctx = new MonitorContext();
        ctx.setDomain(this.domain);
        ctx.setApp(this.app);
        ctx.setCluster(this.cluster);
        ctx.setCollectTime(new Date());
        ctx.setPID(this.pid);
        ctx.setHost(this.host);
        ctx.setCollectTime(Utils.getStartTime());
        return ctx;
    }

    private void collectSpringMethod() {
        if (!this.collectSpringMethodEnable) {
            return;
        }
        ArrayList<SpringMethodStatValue> statValueList = new ArrayList<SpringMethodStatValue>();
        Set<Object> stats = SpringStatManager.getInstance().getSpringStatSet();
        for (Object item : stats) {
            if (!(item instanceof SpringStat)) continue;
            SpringStat sprintStat = (SpringStat)item;
            statValueList.addAll(sprintStat.getStatList(true));
        }
        if (statValueList.size() > 0) {
            MonitorContext ctx = this.createContext();
            this.dao.saveSpringMethod(ctx, statValueList);
        }
    }

    private void collectWebURI() {
        if (!this.collectWebAppEnable && !this.collectWebURIEnable) {
            return;
        }
        ArrayList<WebURIStatValue> webURIValueList = new ArrayList<WebURIStatValue>();
        ArrayList<WebAppStatValue> webAppStatValueList = new ArrayList<WebAppStatValue>();
        Set<Object> stats = WebAppStatManager.getInstance().getWebAppStatSet();
        for (Object item : stats) {
            if (!(item instanceof WebAppStat)) continue;
            WebAppStat webAppStat = (WebAppStat)item;
            if (this.collectWebAppEnable) {
                WebAppStatValue webAppStatValue = webAppStat.getStatValue(true);
                webAppStatValueList.add(webAppStatValue);
            }
            if (!this.collectWebURIEnable) continue;
            webURIValueList.addAll(webAppStat.getURIStatValueList(true));
        }
        MonitorContext ctx = this.createContext();
        if (webURIValueList.size() > 0) {
            this.dao.saveWebURI(ctx, webURIValueList);
        }
        if (webAppStatValueList.size() > 0) {
            this.dao.saveWebApp(ctx, webAppStatValueList);
        }
    }

    public List<JdbcSqlStatValue> loadSqlList(Map<String, Object> filters) {
        return this.dao.loadSqlList(filters);
    }

    public MonitorDao getDao() {
        return this.dao;
    }

    public void setDao(MonitorDao dao) {
        this.dao = dao;
    }

    public long getTimeBetweenSqlCollect() {
        return this.timeBetweenSqlCollect;
    }

    public void setTimeBetweenSqlCollect(long timeBetweenSqlCollect) {
        this.timeBetweenSqlCollect = timeBetweenSqlCollect;
    }

    public long getTimeBetweenSpringCollect() {
        return this.timeBetweenSpringCollect;
    }

    public void setTimeBetweenSpringCollect(long timeBetweenSpringCollect) {
        this.timeBetweenSpringCollect = timeBetweenSpringCollect;
    }

    public long getTimeBetweenWebUriCollect() {
        return this.timeBetweenWebUriCollect;
    }

    public void setTimeBetweenWebUriCollect(long timeBetweenWebUriCollect) {
        this.timeBetweenWebUriCollect = timeBetweenWebUriCollect;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isCollectSqlEnable() {
        return this.collectSqlEnable;
    }

    public void setCollectSqlEnable(boolean collectSqlEnable) {
        this.collectSqlEnable = collectSqlEnable;
    }

    public boolean isCollectSqlWallEnable() {
        return this.collectSqlWallEnable;
    }

    public void setCollectSqlWallEnable(boolean collectSqlWallEnable) {
        this.collectSqlWallEnable = collectSqlWallEnable;
    }

    public boolean isCollectSpringMethodEnable() {
        return this.collectSpringMethodEnable;
    }

    public void setCollectSpringMethodEnable(boolean collectSpringMethodEnable) {
        this.collectSpringMethodEnable = collectSpringMethodEnable;
    }

    public boolean isCollectWebAppEnable() {
        return this.collectWebAppEnable;
    }

    public void setCollectWebAppEnable(boolean collectWebAppEnable) {
        this.collectWebAppEnable = collectWebAppEnable;
    }

    public boolean isCollectWebURIEnable() {
        return this.collectWebURIEnable;
    }

    public void setCollectWebURIEnable(boolean collectWebURIEnable) {
        this.collectWebURIEnable = collectWebURIEnable;
    }

    public int getSchedulerThreadSize() {
        return this.schedulerThreadSize;
    }

    public void setSchedulerThreadSize(int schedulerThreadSize) {
        this.schedulerThreadSize = schedulerThreadSize;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public static InetAddress getLocalIPAddress() {
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress inetAddress = null;
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    inetAddress = e2.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.getHostAddress().contains(":")) continue;
                    return inetAddress;
                }
            }
        }
        catch (Exception e) {
            LOG.error("getLocalIP error", e);
        }
        return null;
    }
}

